/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.rendering;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBeam;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXLink;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXWireless;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ENetFXHandlerClientWireless
extends ENetFXHandler<TileCrystalWirelessIO> {
    protected CrystalFXBase staticFX;
    protected LinkedList<CrystalFXBase> beamFXList = new LinkedList();
    protected LinkedList<CrystalFXBase> transferFXList = new LinkedList();
    protected LinkedList<CrystalFXBase> linkFX = null;

    public ENetFXHandlerClientWireless(TileCrystalWirelessIO tile) {
        super(tile);
    }

    @Override
    public void update() {
        int i;
        if (((TileCrystalWirelessIO)this.tile).hasStaticFX()) {
            if (this.staticFX == null || !this.staticFX.isAlive()) {
                this.staticFX = ((TileCrystalWirelessIO)this.tile).createStaticFX();
                DEParticles.addParticleDirect(((TileCrystalWirelessIO)this.tile).getLevel(), this.staticFX);
            }
            this.staticFX.updateFX(0.5f);
        }
        boolean requiresUpdate = false;
        for (CrystalFXBase beam : this.beamFXList) {
            if (!beam.isAlive()) {
                requiresUpdate = true;
            }
            i = this.beamFXList.indexOf((Object)beam);
            if (((TileCrystalWirelessIO)this.tile).flowRates.size() <= i || i < 0) continue;
            beam.updateFX((float)((Byte)((TileCrystalWirelessIO)this.tile).flowRates.get((byte)i) & 0xFF) / 255.0f);
        }
        for (CrystalFXBase transFX : this.transferFXList) {
            if (!transFX.isAlive()) {
                requiresUpdate = true;
            }
            i = this.transferFXList.indexOf((Object)transFX);
            if (((TileCrystalWirelessIO)this.tile).receiverFlowRates.size() <= i || i < 0) continue;
            transFX.updateFX((float)(((TileCrystalWirelessIO)this.tile).receiverFlowRates.get(i) & 0xFF) / 255.0f);
        }
        if (requiresUpdate || ((TileCrystalWirelessIO)this.tile).getReceivers().size() != this.transferFXList.size() || ((TileCrystalWirelessIO)this.tile).getLinks().size() != this.beamFXList.size()) {
            this.reloadConnections();
        }
        if (ClientEventHandler.playerHoldingWrench) {
            if (this.linkFX == null || this.linkFX.size() != ((TileCrystalWirelessIO)this.tile).getReceivers().size()) {
                if (this.linkFX != null) {
                    for (CrystalFXBase fx : this.linkFX) {
                        fx.remove();
                    }
                }
                this.linkFX = new LinkedList();
                for (BlockPos receiver : ((TileCrystalWirelessIO)this.tile).getReceivers()) {
                    CrystalFXLink link = new CrystalFXLink((ClientLevel)((TileCrystalWirelessIO)this.tile).getLevel(), (TileCrystalBase)this.tile, Vec3D.getCenter((BlockPos)receiver));
                    this.linkFX.add(link);
                    DEParticles.addParticleDirect(((TileCrystalWirelessIO)this.tile).getLevel(), link);
                }
            }
        } else if (this.linkFX != null) {
            this.linkFX = null;
        }
    }

    @Override
    public void updateReceived(CrystalUpdateBatcher.BatchedCrystalUpdate update) {
        byte index;
        ((TileCrystalWirelessIO)this.tile).modifyEnergyStored(update.crystalCapacity - ((TileCrystalWirelessIO)this.tile).getEnergyStored());
        Map<Byte, Byte> flowMap = update.indexToFlowMap;
        for (index = 0; index < ((TileCrystalWirelessIO)this.tile).flowRates.size(); index = (byte)(index + 1)) {
            if (flowMap.containsKey(index)) continue;
            flowMap.put(index, (Byte)((TileCrystalWirelessIO)this.tile).flowRates.get(index));
        }
        for (index = 0; index < ((TileCrystalWirelessIO)this.tile).receiverFlowRates.size(); index = (byte)(index + 1)) {
            if (flowMap.containsKey((byte)(index + 128))) continue;
            flowMap.put((byte)(index + 128), ((TileCrystalWirelessIO)this.tile).receiverFlowRates.get(index));
        }
        ((TileCrystalWirelessIO)this.tile).flowRates.clear();
        ((TileCrystalWirelessIO)this.tile).receiverFlowRates.clear();
        for (byte b : flowMap.keySet()) {
            if ((b & 0xFF) >= 128) {
                ((TileCrystalWirelessIO)this.tile).receiverFlowRates.add(flowMap.get(b));
                continue;
            }
            ((TileCrystalWirelessIO)this.tile).flowRates.add(flowMap.get(b));
        }
    }

    @Override
    public void reloadConnections() {
        this.beamFXList.clear();
        this.transferFXList.clear();
        for (BlockPos pos : ((TileCrystalWirelessIO)this.tile).getLinks()) {
            BlockEntity target = ((TileCrystalWirelessIO)this.tile).getLevel().getBlockEntity(pos);
            if (!(target instanceof ICrystalLink)) continue;
            CrystalFXBeam<BlockEntity> beam = new CrystalFXBeam<BlockEntity>(((TileCrystalWirelessIO)this.tile).getLevel(), this.tile, (ICrystalLink)target);
            this.beamFXList.add(beam);
            DEParticles.addParticleDirect(((TileCrystalWirelessIO)this.tile).getLevel(), beam);
        }
        for (BlockPos pos : ((TileCrystalWirelessIO)this.tile).getReceivers()) {
            CrystalFXWireless wirelessFX = new CrystalFXWireless((ClientLevel)((TileCrystalWirelessIO)this.tile).getLevel(), (TileCrystalWirelessIO)this.tile, pos);
            this.transferFXList.add(wirelessFX);
            DEParticles.addParticleDirect(((TileCrystalWirelessIO)this.tile).getLevel(), wirelessFX);
        }
    }

    @Override
    public void tileUnload() {
        super.tileUnload();
    }
}

