/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.GuiRender;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.UndyingData;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.ItemData;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class UndyingEntity
extends ModuleEntity<UndyingData> {
    private int charge;
    private int invulnerableTime = 0;
    public static final Codec<UndyingEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(ModuleEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)Codec.INT.fieldOf("charge").forGetter(e -> e.charge), (App)Codec.INT.fieldOf("invul_time").forGetter(e -> e.invulnerableTime)).apply((Applicative)builder, UndyingEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, UndyingEntity> STREAM_CODEC = StreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, (StreamCodec)ByteBufCodecs.INT, e -> e.charge, (StreamCodec)ByteBufCodecs.INT, e -> e.invulnerableTime, UndyingEntity::new);

    public UndyingEntity(Module<UndyingData> module) {
        super(module);
    }

    UndyingEntity(Module<?> module, int gridX, int gridY, int charge, int invulnerableTime) {
        super(module, gridX, gridY);
        this.charge = charge;
        this.invulnerableTime = invulnerableTime;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new UndyingEntity(this.module, this.getGridX(), this.getGridY(), this.charge, this.invulnerableTime);
    }

    @Override
    public void onInstalled(ModuleContext context) {
        super.onInstalled(context);
        this.invulnerableTime = 0;
    }

    @Override
    public void tick(ModuleContext moduleContext) {
        if (this.invulnerableTime > 0) {
            LivingEntity entity;
            --this.invulnerableTime;
            this.markDirty();
            if (moduleContext instanceof StackModuleContext && (entity = ((StackModuleContext)moduleContext).getEntity()) instanceof Player) {
                if (this.invulnerableTime == 0) {
                    ((Player)entity).displayClientMessage((Component)Component.literal((String)""), true);
                } else {
                    ((Player)entity).displayClientMessage((Component)Component.translatable((String)"module.draconicevolution.undying.invuln.active", (Object[])new Object[]{MathUtils.round((double)((double)this.invulnerableTime / 20.0), (double)10.0)}).withStyle(ChatFormatting.GOLD), true);
                }
            }
        }
        IOPStorage storage = moduleContext.getOpStorage();
        if (!(moduleContext instanceof StackModuleContext) || !EffectiveSide.get().isServer() || storage == null) {
            return;
        }
        StackModuleContext context = (StackModuleContext)moduleContext;
        UndyingData data = (UndyingData)this.module.getData();
        if (!context.isEquipped() || this.charge >= data.chargeTime()) {
            return;
        }
        if (storage.getOPStored() >= data.getChargeEnergyRate()) {
            storage.modifyEnergyStored(-data.getChargeEnergyRate());
            ++this.charge;
            this.markDirty();
        }
    }

    public boolean tryBlockDamage(LivingIncomingDamageEvent event) {
        if (this.invulnerableTime > 0) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public boolean tryBlockDamage(LivingDamageEvent.Pre event) {
        if (this.invulnerableTime > 0) {
            event.setNewDamage(0.0f);
            return true;
        }
        return false;
    }

    public boolean isCharged() {
        UndyingData data = (UndyingData)this.module.getData();
        return this.charge >= data.chargeTime();
    }

    public double getCharge() {
        UndyingData data = (UndyingData)this.module.getData();
        return (double)this.charge / (double)data.chargeTime();
    }

    public boolean tryBlockDeath(LivingDeathEvent event) {
        if (event.getSource().is(DEDamage.GUARDIAN_LASER) && this.invulnerableTime > 0) {
            event.getEntity().setHealth(event.getEntity().getHealth() + 1.0f);
            return true;
        }
        UndyingData data = (UndyingData)this.module.getData();
        if (this.charge >= data.chargeTime()) {
            LivingEntity entity = event.getEntity();
            entity.setHealth(entity.getHealth() + data.healthBoost());
            ItemStack stack = entity.getItemBySlot(EquipmentSlot.CHEST);
            if (!stack.isEmpty()) {
                try (ModuleHost stackHost = DECapabilities.getHost(stack);){
                    ShieldControlEntity shield;
                    if (stackHost != null && (shield = (ShieldControlEntity)stackHost.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null)) != null) {
                        shield.boost(data.shieldBoost(), data.shieldBoostTime());
                    }
                }
            }
            if (this.module.getModuleTechLevel().index >= 2) {
                entity.clearFire();
                Iterator iterator = entity.getActiveEffectsMap().values().iterator();
                while (iterator.hasNext()) {
                    MobEffectInstance effect = (MobEffectInstance)iterator.next();
                    if (((MobEffect)effect.getEffect().value()).isBeneficial()) continue;
                    entity.onEffectRemoved(effect);
                    iterator.remove();
                }
            }
            this.charge = 0;
            DraconicNetwork.sendUndyingActivation(entity, this.module.getItem());
            entity.level().playSound(null, entity.blockPosition(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 5.0f, 0.95f + entity.level().random.nextFloat() * 0.1f);
            this.invulnerableTime = data.invulnerableTime();
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, boolean renderStack, float partialTicks) {
        super.renderModule(parent, render, x, y, width, height, mouseX, mouseY, renderStack, partialTicks);
        UndyingData data = (UndyingData)this.module.getData();
        if (this.charge >= data.chargeTime()) {
            return;
        }
        double progress = (double)this.charge / Math.max(1.0, (double)data.chargeTime());
        String pText = (int)(progress * 100.0) + "%";
        String tText = (data.chargeTime() - this.charge) / 20 + "s";
        this.drawChargeProgress(render, x, y, width, height, progress, pText, tText);
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        stack.set(ItemData.UNDYING_MODULE_CHARGE, (Object)this.charge);
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        this.charge = (Integer)stack.getOrDefault(ItemData.UNDYING_MODULE_CHARGE, (Object)0);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UndyingEntity)) {
            return false;
        }
        UndyingEntity that = (UndyingEntity)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.charge == that.charge && this.invulnerableTime == that.invulnerableTime;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.charge, this.invulnerableTime);
    }
}

