/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class IntegerProperty
extends ConfigProperty {
    private int value;
    private ConfigProperty.IntegerFormatter formatter = ConfigProperty.IntegerFormatter.RAW;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    private BiConsumer<ItemStack, IntegerProperty> changeListener = null;
    public static final Codec<IntegerProperty> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(e -> e.name), (App)Codec.BOOL.fieldOf("show_on_hud").forGetter(e -> e.showOnHud), (App)UUIDUtil.CODEC.optionalFieldOf("unique_name").forGetter(ConfigProperty::getOptionalUniqueName), (App)Codec.INT.fieldOf("value").forGetter(e -> e.value), (App)Codec.INT.fieldOf("min").forGetter(e -> e.min), (App)Codec.INT.fieldOf("max").forGetter(e -> e.max), (App)ConfigProperty.IntegerFormatter.CODEC.fieldOf("formatter").forGetter(e -> e.formatter)).apply((Applicative)builder, IntegerProperty::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, IntegerProperty> STREAM_CODEC = NeoForgeStreamCodecs.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, e -> e.name, (StreamCodec)ByteBufCodecs.BOOL, e -> e.showOnHud, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), ConfigProperty::getOptionalUniqueName, (StreamCodec)ByteBufCodecs.INT, e -> e.value, (StreamCodec)ByteBufCodecs.INT, e -> e.min, (StreamCodec)ByteBufCodecs.INT, e -> e.max, ConfigProperty.IntegerFormatter.STREAM_CODEC, e -> e.formatter, IntegerProperty::new);

    public IntegerProperty(String name, int defaultValue) {
        super(name);
        this.value = defaultValue;
    }

    public IntegerProperty(String name, Component displayName, int defaultValue) {
        super(name, displayName);
        this.value = defaultValue;
    }

    IntegerProperty(String name, boolean showOnHud, Optional<UUID> uniqueName, int value, int min, int max, ConfigProperty.IntegerFormatter formatter) {
        super(name, showOnHud, uniqueName);
        this.value = value;
        this.min = min;
        this.max = max;
        this.formatter = formatter;
    }

    @Override
    public IntegerProperty copy() {
        return new IntegerProperty(this.name, this.showOnHud, Optional.ofNullable(this.uniqueName), this.value, this.min, this.max, this.formatter);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = MathHelper.clip((int)value, (int)this.getMin(), (int)this.getMax());
    }

    public IntegerProperty min(int minValue) {
        this.min = minValue;
        this.validateValue();
        return this;
    }

    public IntegerProperty max(int maxValue) {
        this.max = maxValue;
        this.validateValue();
        return this;
    }

    public IntegerProperty range(int minValue, int maxValue) {
        this.min = minValue;
        this.max = maxValue;
        this.validateValue();
        return this;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public String getDisplayValue() {
        return this.formatter.format(this.getValue());
    }

    @Override
    public void onValueChanged(ItemStack stack) {
        if (this.provider != null) {
            this.provider.markDirty();
        }
        if (this.changeListener != null) {
            this.changeListener.accept(stack, this);
        }
    }

    @Override
    public void validateValue() {
        this.value = Math.max(this.getMin(), Math.min(this.getMax(), this.value));
    }

    @Override
    public ConfigProperty.Type getType() {
        return ConfigProperty.Type.INTEGER;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.run();
    }

    public void setChangeListener(Consumer<ItemStack> changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.accept((ItemStack)stack);
    }

    public void setChangeListener(BiConsumer<ItemStack, IntegerProperty> changeListener) {
        this.changeListener = changeListener;
    }

    public IntegerProperty setFormatter(ConfigProperty.IntegerFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public ConfigProperty.IntegerFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void loadData(PropertyData data, ItemStack stack) {
        this.value = Math.max(this.getMin(), Math.min(this.getMax(), data.integerValue));
        this.onValueChanged(stack);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IntegerProperty)) {
            return false;
        }
        IntegerProperty that = (IntegerProperty)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.value == that.value && this.min == that.min && this.max == that.max && this.formatter == that.formatter;
    }

    @Override
    public boolean equalsWOValue(Object o) {
        if (!(o instanceof IntegerProperty)) {
            return false;
        }
        IntegerProperty that = (IntegerProperty)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.min == that.min && this.max == that.max && this.formatter == that.formatter;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.value, this.formatter, this.min, this.max});
    }

    public String toString() {
        return "IntegerProperty{value=" + this.value + "}";
    }
}

