/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class DecimalProperty
extends ConfigProperty {
    private double value;
    private ConfigProperty.DecimalFormatter formatter = ConfigProperty.DecimalFormatter.RAW_2;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private BiConsumer<ItemStack, DecimalProperty> changeListener = null;
    public static final Codec<DecimalProperty> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(e -> e.name), (App)Codec.BOOL.fieldOf("show_on_hud").forGetter(e -> e.showOnHud), (App)UUIDUtil.CODEC.optionalFieldOf("unique_name").forGetter(ConfigProperty::getOptionalUniqueName), (App)Codec.DOUBLE.fieldOf("value").forGetter(e -> e.value), (App)Codec.DOUBLE.fieldOf("min").forGetter(e -> e.min), (App)Codec.DOUBLE.fieldOf("max").forGetter(e -> e.max), (App)ConfigProperty.DecimalFormatter.CODEC.fieldOf("formatter").forGetter(e -> e.formatter)).apply((Applicative)builder, DecimalProperty::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DecimalProperty> STREAM_CODEC = NeoForgeStreamCodecs.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, e -> e.name, (StreamCodec)ByteBufCodecs.BOOL, e -> e.showOnHud, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), ConfigProperty::getOptionalUniqueName, (StreamCodec)ByteBufCodecs.DOUBLE, e -> e.value, (StreamCodec)ByteBufCodecs.DOUBLE, e -> e.min, (StreamCodec)ByteBufCodecs.DOUBLE, e -> e.max, ConfigProperty.DecimalFormatter.STREAM_CODEC, e -> e.formatter, DecimalProperty::new);

    public DecimalProperty(String name, double defaultValue) {
        super(name);
        this.value = defaultValue;
    }

    public DecimalProperty(String name, Component displayName, double defaultValue) {
        super(name, displayName);
        this.value = defaultValue;
    }

    DecimalProperty(String name, boolean showOnHud, Optional<UUID> uniqueName, double value, double min, double max, ConfigProperty.DecimalFormatter formatter) {
        super(name, showOnHud, uniqueName);
        this.value = value;
        this.min = min;
        this.max = max;
        this.formatter = formatter;
    }

    @Override
    public DecimalProperty copy() {
        return new DecimalProperty(this.name, this.showOnHud, Optional.ofNullable(this.uniqueName), this.value, this.min, this.max, this.formatter);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = MathHelper.clip((double)value, (double)this.getMin(), (double)this.getMax());
    }

    public DecimalProperty min(double minValue) {
        this.min = minValue;
        this.validateValue();
        return this;
    }

    public DecimalProperty max(double maxValue) {
        this.max = maxValue;
        this.validateValue();
        return this;
    }

    public DecimalProperty range(double minValue, double maxValue) {
        this.min = minValue;
        this.max = maxValue;
        this.validateValue();
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public String getDisplayValue() {
        return this.formatter.format(this.getValue());
    }

    @Override
    public void onValueChanged(ItemStack stack) {
        if (this.provider != null) {
            this.provider.markDirty();
        }
        if (this.changeListener != null) {
            this.changeListener.accept(stack, this);
        }
    }

    @Override
    public void validateValue() {
        this.value = Math.max(this.getMin(), Math.min(this.getMax(), this.value));
    }

    @Override
    public ConfigProperty.Type getType() {
        return ConfigProperty.Type.DECIMAL;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.run();
    }

    public void setChangeListener(Consumer<ItemStack> changeListener) {
        this.changeListener = (stack, integerProperty) -> changeListener.accept((ItemStack)stack);
    }

    public void setChangeListener(BiConsumer<ItemStack, DecimalProperty> changeListener) {
        this.changeListener = changeListener;
    }

    public DecimalProperty setFormatter(ConfigProperty.DecimalFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public ConfigProperty.DecimalFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void loadData(PropertyData data, ItemStack stack) {
        this.value = Math.max(this.getMin(), Math.min(this.getMax(), data.decimalValue));
        this.onValueChanged(stack);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DecimalProperty)) {
            return false;
        }
        DecimalProperty that = (DecimalProperty)o;
        if (!super.equals(o)) {
            return false;
        }
        return Double.compare(this.value, that.value) == 0 && Double.compare(this.min, that.min) == 0 && Double.compare(this.max, that.max) == 0 && this.formatter == that.formatter;
    }

    @Override
    public boolean equalsWOValue(Object o) {
        if (!(o instanceof DecimalProperty)) {
            return false;
        }
        DecimalProperty that = (DecimalProperty)o;
        if (!super.equals(o)) {
            return false;
        }
        return Double.compare(this.min, that.min) == 0 && Double.compare(this.max, that.max) == 0 && this.formatter == that.formatter;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.value, this.formatter, this.min, this.max});
    }

    public String toString() {
        return "DecimalProperty{value=" + this.value + "}";
    }
}

