/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.network.event.internal.IncompatibleMessageInternalEvent;
import com.seibel.distanthorizons.core.network.event.internal.ProtocolErrorInternalEvent;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.network.messages.MessageRegistry;
import com.seibel.distanthorizons.core.network.messages.base.CloseReasonMessage;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IPluginPacketSender;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;

public abstract class AbstractPluginPacketSender
implements IPluginPacketSender {
    private static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Common.Logging.logNetworkEvent.get());
    public static final class_2960 WRAPPER_PACKET_RESOURCE = class_2960.method_60655((String)"distant_horizons", (String)"message");
    private final boolean forgeByteInProtocolVersion;

    public AbstractPluginPacketSender() {
        this(false);
    }

    public AbstractPluginPacketSender(boolean forgeByteInProtocolVersion) {
        this.forgeByteInProtocolVersion = forgeByteInProtocolVersion;
    }

    @Override
    public final void sendToClient(IServerPlayerWrapper serverPlayer, AbstractNetworkMessage message) {
        this.sendToClient((class_3222)serverPlayer.getWrappedMcObject(), message);
    }

    public abstract void sendToClient(class_3222 var1, AbstractNetworkMessage var2);

    @Override
    public abstract void sendToServer(AbstractNetworkMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNetworkMessage decodeMessage(class_2540 in) {
        AbstractNetworkMessage message = null;
        try {
            short protocolVersion;
            in.method_52932();
            short s = protocolVersion = this.forgeByteInProtocolVersion ? in.readByte() : in.readShort();
            if (protocolVersion != 11) {
                IncompatibleMessageInternalEvent incompatibleMessageInternalEvent = new IncompatibleMessageInternalEvent(protocolVersion);
                return incompatibleMessageInternalEvent;
            }
            message = MessageRegistry.INSTANCE.createMessage(in.readUnsignedShort());
            message.decode((ByteBuf)in);
            if (in.isReadable()) {
                throw new IOException("Buffer has not been fully read");
            }
            AbstractNetworkMessage abstractNetworkMessage = message;
            return abstractNetworkMessage;
        }
        catch (Exception e) {
            in.method_52933();
            LOGGER.error("Failed to decode message", e);
            LOGGER.error("Buffer: [" + String.valueOf(in) + "]", new Object[0]);
            LOGGER.error("Buffer contents: [" + ByteBufUtil.hexDump((ByteBuf)in) + "]", new Object[0]);
            ProtocolErrorInternalEvent protocolErrorInternalEvent = new ProtocolErrorInternalEvent(e, message, true);
            return protocolErrorInternalEvent;
        }
        finally {
            in.method_52988(in.writerIndex());
        }
    }

    public void encodeMessage(class_2540 out, AbstractNetworkMessage message) {
        Objects.requireNonNull(message);
        if (this.forgeByteInProtocolVersion) {
            out.method_52997(11);
        } else {
            out.method_52998(11);
        }
        try {
            out.method_52934();
            out.method_52998(MessageRegistry.INSTANCE.getMessageId(message));
            message.encode((ByteBuf)out);
        }
        catch (Exception e) {
            LOGGER.error("Failed to encode message", e);
            LOGGER.error("Message: [" + String.valueOf(message) + "]", new Object[0]);
            message.getSession().tryHandleMessage(new ProtocolErrorInternalEvent(e, message, false));
            out.method_52935();
            message = new CloseReasonMessage("Internal error on other side");
            out.method_52998(MessageRegistry.INSTANCE.getMessageId(message));
            message.encode((ByteBuf)out);
        }
    }
}

