/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.spellbinder;

import alexthw.not_enough_glyphs.common.spellbinder.SpellBinderContainer;
import alexthw.not_enough_glyphs.init.NotEnoughGlyphs;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SpellBinderScreen
extends AbstractContainerScreen<SpellBinderContainer> {
    public static final ResourceLocation BACKGROUND = NotEnoughGlyphs.prefix("textures/gui/spell_binder.png");

    public SpellBinderScreen(SpellBinderContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    protected void renderBg(@NotNull GuiGraphics gui, float partialTicks, int x, int y) {
        gui.blit(BACKGROUND, this.leftPos - 40, this.topPos - 40, 0, 0, 256, 256);
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
        this.renderGlyphPreview(gui, this.leftPos + 8, this.topPos + 8);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderLabels(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    protected void init() {
        super.init();
        this.titleLabelX = 8;
        this.titleLabelY = -20;
    }

    protected void renderTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        if (((SpellBinderContainer)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            ItemStack itemstack = this.hoveredSlot.getItem();
            gui.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, mouseX, mouseY);
        }
    }

    public void renderGlyphPreview(GuiGraphics gui, int x, int y) {
        if (((SpellBinderContainer)this.menu).binder.isEmpty()) {
            return;
        }
        AbstractCaster spellCaster = SpellCasterRegistry.from((ItemStack)((SpellBinderContainer)this.menu).binder);
        if (spellCaster == null) {
            return;
        }
        int offsetX = 0;
        int offsetY = -26;
        for (int i = 0; i < spellCaster.getMaxSlots(); ++i) {
            if (i % 2 == 0) {
                offsetY += 23;
                offsetX = 0;
            } else {
                offsetX += 40;
            }
            Spell spell = spellCaster.getSpell(i);
            AbstractSpellPart primaryIcon = null;
            AbstractSpellPart secondaryIcon = null;
            for (AbstractSpellPart p : spell.recipe()) {
                if (p instanceof AbstractCastMethod) {
                    primaryIcon = p;
                }
                if (!(p instanceof AbstractEffect)) continue;
                secondaryIcon = p;
                break;
            }
            if (primaryIcon != null) {
                RenderUtils.drawSpellPart((AbstractSpellPart)primaryIcon, (GuiGraphics)gui, (int)(x + offsetX + 6), (int)(y + offsetY - 20), (int)8, (boolean)false);
            }
            if (secondaryIcon == null) continue;
            RenderUtils.drawSpellPart((AbstractSpellPart)secondaryIcon, (GuiGraphics)gui, (int)(x + offsetX + 6), (int)(y + offsetY - 10), (int)12, (boolean)false);
        }
    }
}

