/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.supermartijn642.fusion.model.WrappedBakedModel;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemBakedModel
extends WrappedBakedModel {
    private final List<BakedModel> asList = List.of(this);
    private ItemStack stack;
    private boolean fabulous;

    public ItemBakedModel(BakedModel original) {
        super(original);
    }

    protected abstract List<BakedQuad> getQuads(ItemStack var1, boolean var2, @NotNull RandomSource var3, @NotNull ModelData var4, @Nullable RenderType var5);

    @Override
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, @NotNull RandomSource random, @NotNull ModelData data, @Nullable RenderType renderType) {
        return this.getQuads(this.stack, this.fabulous, random, data, renderType);
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, RandomSource random) {
        return this.getQuads(this.stack, this.fabulous, random, ModelData.EMPTY, null);
    }

    public void set(ItemStack stack, boolean fabulous) {
        this.stack = stack;
        this.fabulous = fabulous;
    }

    public List<BakedModel> asList() {
        return this.asList;
    }

    public static RenderType getNonModelRenderType(ItemStack stack, boolean fabulous) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            ChunkRenderTypeSet renderTypes = ItemBlockRenderTypes.getRenderLayers((BlockState)blockItem.getBlock().defaultBlockState());
            if (renderTypes.contains(RenderType.translucent())) {
                return RenderTypeHelper.getEntityRenderType((RenderType)RenderType.translucent(), (boolean)fabulous);
            }
            return Sheets.cutoutBlockSheet();
        }
        return fabulous ? Sheets.translucentCullBlockSheet() : Sheets.translucentItemSheet();
    }
}

