/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model.loader;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.entity.model.loader.BedrockEntityModelLoader;
import com.supermartijn642.fusion.entity.model.loader.EntityModelLoader;
import com.supermartijn642.fusion.entity.model.loader.OptifineEntityModelLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class FusionEntityModelLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final List<Pair<String, EntityModelLoader>> LOADERS = List.of(Pair.of(".geo.json", new BedrockEntityModelLoader()), Pair.of(".jem", new OptifineEntityModelLoader()));
    public static Map<ResourceLocation, ModelPart> MODELS = Map.of();

    public static ResourceLocation locationForLayer(ModelLayerLocation layer) {
        String layerFormatted = layer.getLayer().toLowerCase(Locale.ROOT).replace(':', '/').replaceAll("[a-z0-9/._-]", "");
        return layer.getModel().withSuffix("/" + layerFormatted);
    }

    public static void loadModels(List<ResourceLocation> identifiers, ResourceManager resourceManager) {
        Map<PackResources, Integer> packOrder = Collections.emptyMap();
        if (resourceManager instanceof MultiPackResourceManager || resourceManager instanceof ReloadableResourceManager && ((ReloadableResourceManager)resourceManager).resources instanceof MultiPackResourceManager) {
            List packs = resourceManager instanceof ReloadableResourceManager ? ((MultiPackResourceManager)((ReloadableResourceManager)resourceManager).resources).packs : ((MultiPackResourceManager)resourceManager).packs;
            packOrder = new HashMap(packs.size());
            for (int index = 0; index < packs.size(); ++index) {
                packOrder.put((PackResources)packs.get(index), index);
            }
        }
        ImmutableMap.Builder models = ImmutableMap.builder();
        for (ResourceLocation identifier : identifiers) {
            ModelPart model;
            Resource resource = null;
            EntityModelLoader modelLoader = null;
            ResourceLocation location = null;
            int packIndex = -1;
            for (Pair<String, EntityModelLoader> loader : LOADERS) {
                Resource r;
                int index;
                ResourceLocation l = ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)("fusion/entity_models/" + identifier.getPath() + loader.left()));
                Optional optional = resourceManager.getResource(l);
                if (!optional.isPresent() || (index = ((Integer)packOrder.get((r = (Resource)optional.get()).source())).intValue()) <= packIndex) continue;
                resource = r;
                modelLoader = loader.right();
                location = l;
                packIndex = index;
            }
            if (resource == null || (model = FusionEntityModelLoader.loadModel(location, resource, modelLoader)) == null) continue;
            models.put((Object)identifier, (Object)model);
        }
        MODELS = models.build();
    }

    private static ModelPart loadModel(ResourceLocation location, Resource resource, EntityModelLoader loader) {
        JsonObject json = new JsonObject();
        try (BufferedReader input = resource.openAsReader();){
            json = (JsonObject)GSON.fromJson((Reader)input, JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read resource for '" + String.valueOf(location) + "' from pack '" + String.valueOf(resource.source().location().title()), e);
        }
        catch (JsonSyntaxException e) {
            FusionClient.LOGGER.error("Failed to parse json for '{}' from pack '{}': {}", new Object[]{location, resource.source().location().title(), e.getMessage()});
        }
        if (json == null) {
            return null;
        }
        try {
            return loader.loadModel(json);
        }
        catch (JsonParseException e) {
            FusionClient.LOGGER.error("Failed to load entity model for '{}' from pack '{}': {}", new Object[]{location, resource.source().location().title().getString(), e.getMessage()});
            return null;
        }
    }
}

