/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import com.logisticscraft.occlusionculling.util.Vec3d;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.NMSCullingHelper;
import dev.tr7zw.entityculling.versionless.EntityCullingVersionlessBase;
import dev.tr7zw.entityculling.versionless.access.Cullable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CullTask
implements Runnable {
    public boolean requestCull = false;
    public boolean disableEntityCulling = false;
    public boolean disableBlockEntityCulling = false;
    private final OcclusionCullingInstance culling;
    private final Minecraft client = Minecraft.getInstance();
    private final int sleepDelay;
    private final int hitboxLimit;
    private final Set<BlockEntityType<?>> blockEntityWhitelist;
    private final Set<EntityType<?>> entityWhistelist;
    public long lastTime;
    private Vec3d lastPos;
    private Vec3d aabbMin;
    private Vec3d aabbMax;

    public CullTask(OcclusionCullingInstance culling, Set<BlockEntityType<?>> blockEntityWhitelist, Set<EntityType<?>> entityWhistelist) {
        this.sleepDelay = EntityCullingModBase.instance.config.sleepDelay;
        this.hitboxLimit = EntityCullingModBase.instance.config.hitboxLimit;
        this.lastTime = 0L;
        this.lastPos = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMin = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMax = new Vec3d(0.0, 0.0, 0.0);
        this.culling = culling;
        this.blockEntityWhitelist = blockEntityWhitelist;
        this.entityWhistelist = entityWhistelist;
    }

    @Override
    public void run() {
        while (this.client.isRunning()) {
            try {
                Vec3 cameraMC;
                Thread.sleep(this.sleepDelay);
                if (!EntityCullingVersionlessBase.enabled || this.client.level == null || this.client.player == null || this.client.player.tickCount <= 10) continue;
                Vec3 vec3 = cameraMC = EntityCullingModBase.instance.config.debugMode ? this.client.player.getEyePosition(0.0f) : this.client.gameRenderer.getMainCamera().getPosition();
                if (!this.requestCull && cameraMC.x == this.lastPos.x && cameraMC.y == this.lastPos.y && cameraMC.z == this.lastPos.z) continue;
                long start = System.currentTimeMillis();
                this.requestCull = false;
                this.lastPos.set(cameraMC.x, cameraMC.y, cameraMC.z);
                Vec3d camera = this.lastPos;
                this.culling.resetCache();
                this.cullBlockEntities(cameraMC, camera);
                this.cullEntities(cameraMC, camera);
                this.lastTime = System.currentTimeMillis() - start;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Shutting down culling task!");
    }

    private void cullEntities(Vec3 cameraMC, Vec3d camera) {
        if (this.disableEntityCulling) {
            return;
        }
        Entity entity = null;
        Iterator iterable = this.client.level.entitiesForRendering().iterator();
        while (iterable.hasNext()) {
            Cullable cullable;
            try {
                entity = (Entity)iterable.next();
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException | ConcurrentModificationException ex) {
                break;
            }
            if (entity == null) break;
            if (!(entity instanceof Cullable) || this.entityWhistelist.contains(entity.getType()) || EntityCullingModBase.instance.isDynamicWhitelisted(entity) || (cullable = (Cullable)entity).isForcedVisible()) continue;
            if (Minecraft.getInstance().shouldEntityAppearGlowing(entity) || this.isSkippableArmorstand(entity)) {
                cullable.setCulled(false);
                continue;
            }
            if (!entity.position().closerThan((Position)cameraMC, (double)EntityCullingModBase.instance.config.tracingDistance)) {
                cullable.setCulled(false);
                continue;
            }
            AABB boundingBox = NMSCullingHelper.getCullingBox(entity);
            if (boundingBox.getXsize() > (double)this.hitboxLimit || boundingBox.getYsize() > (double)this.hitboxLimit || boundingBox.getZsize() > (double)this.hitboxLimit) {
                cullable.setCulled(false);
                continue;
            }
            this.aabbMin.set(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
            this.aabbMax.set(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
            boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
            cullable.setCulled(!visible);
        }
    }

    private void cullBlockEntities(Vec3 cameraMC, Vec3d camera) {
        if (this.disableBlockEntityCulling) {
            return;
        }
        for (int x = -8; x <= 8; ++x) {
            block3: for (int z = -8; z <= 8; ++z) {
                LevelChunk chunk = this.client.level.getChunk(this.client.player.chunkPosition().x + x, this.client.player.chunkPosition().z + z);
                Iterator iterator = chunk.getBlockEntities().entrySet().iterator();
                while (iterator.hasNext()) {
                    BlockPos pos;
                    Cullable cullable;
                    Map.Entry entry;
                    try {
                        entry = iterator.next();
                    }
                    catch (NullPointerException | ConcurrentModificationException ex) {
                        continue block3;
                    }
                    if (entry == null) continue block3;
                    if (this.blockEntityWhitelist.contains(((BlockEntity)entry.getValue()).getType()) || this.client.getBlockEntityRenderDispatcher().getRenderer((BlockEntity)entry.getValue()) == null || EntityCullingModBase.instance.isDynamicWhitelisted((BlockEntity)entry.getValue()) || (cullable = (Cullable)entry.getValue()).isForcedVisible() || !CullTask.closerThan(pos = (BlockPos)entry.getKey(), (Position)cameraMC, 64.0)) continue;
                    AABB boundingBox = EntityCullingModBase.instance.setupAABB((BlockEntity)entry.getValue(), pos);
                    if (boundingBox.getXsize() > (double)this.hitboxLimit || boundingBox.getYsize() > (double)this.hitboxLimit || boundingBox.getZsize() > (double)this.hitboxLimit) {
                        cullable.setCulled(false);
                        continue;
                    }
                    this.aabbMin.set(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
                    this.aabbMax.set(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
                    boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
                    cullable.setCulled(!visible);
                }
            }
        }
    }

    private boolean isSkippableArmorstand(Entity entity) {
        if (!EntityCullingModBase.instance.config.skipMarkerArmorStands) {
            return false;
        }
        return entity instanceof ArmorStand && ((ArmorStand)entity).isInvisible();
    }

    private static boolean closerThan(BlockPos blockPos, Position position, double d) {
        return CullTask.distSqr(blockPos, position.x(), position.y(), position.z(), true) < d * d;
    }

    private static double distSqr(BlockPos blockPos, double d, double e, double f, boolean bl) {
        double g = bl ? 0.5 : 0.0;
        double h = (double)blockPos.getX() + g - d;
        double i = (double)blockPos.getY() + g - e;
        double j = (double)blockPos.getZ() + g - f;
        return h * h + i * i + j * j;
    }
}

