/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.rolling;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrh0.createaddition.index.CARecipes;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class RollingRecipe
implements Recipe<RecipeWrapper> {
    protected final ItemStack output;
    protected final Ingredient ingredient;

    public RollingRecipe(String group, Ingredient ingredient, ItemStack output) {
        this.output = output;
        this.ingredient = ingredient;
    }

    public static void register() {
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean matches(RecipeWrapper inv, @NotNull Level level) {
        if (inv.isEmpty()) {
            return false;
        }
        return this.ingredient.test(inv.getItem(0));
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeWrapper recipeWrapper, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 0;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output;
    }

    public ItemStack getResultItem() {
        return this.output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)CARecipes.ROLLING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return CARecipes.ROLLING_TYPE.get();
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return this.output;
    }

    @MethodsReturnNonnullByDefault
    public static class Serializer
    implements RecipeSerializer<RollingRecipe> {
        private static final MapCodec<RollingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.ingredient), (App)ItemStack.CODEC.optionalFieldOf("result", (Object)ItemStack.EMPTY).forGetter(r -> r.output)).apply((Applicative)builder, RollingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RollingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<RollingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RollingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static RollingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            return new RollingRecipe(group, input, output);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, RollingRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
        }
    }
}

