/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.charging;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrh0.createaddition.index.CARecipes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargingRecipe
implements Recipe<RecipeWrapper> {
    public Ingredient ingredient;
    public ItemStack output;
    public int energy;
    public int maxChargeRate;

    public ChargingRecipe(@Nullable String group, Ingredient ingredient, ItemStack output, int energy, int maxChargeRate) {
        this.ingredient = ingredient;
        this.output = output;
        this.energy = energy;
        this.maxChargeRate = maxChargeRate;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(@NotNull RecipeWrapper wrapper, @NotNull Level world) {
        if (this.ingredient == null) {
            return false;
        }
        return this.ingredient.test(wrapper.getItem(0));
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeWrapper recipeWrapper, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output;
    }

    public ItemStack getResultItem() {
        return this.output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)CARecipes.CHARGING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return CARecipes.CHARGING_TYPE.get();
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getMaxChargeRate() {
        return this.maxChargeRate;
    }

    public static class Serializer
    implements RecipeSerializer<ChargingRecipe> {
        private static final MapCodec<ChargingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.output), (App)Codec.INT.optionalFieldOf("energy", (Object)0).forGetter(r -> r.energy), (App)Codec.INT.optionalFieldOf("max_charge_rate", (Object)0).forGetter(r -> r.maxChargeRate)).apply((Applicative)builder, ChargingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ChargingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ChargingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ChargingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ChargingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            int maxChargeRate = buffer.readInt();
            int energy = buffer.readInt();
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            return new ChargingRecipe(group, input, output, energy, maxChargeRate);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ChargingRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeInt(recipe.maxChargeRate);
            buffer.writeInt(recipe.energy);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
        }
    }
}

