/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.redstone_relay;

import com.mrh0.createaddition.blocks.connector.ConnectorType;
import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayBlock;
import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.network.EnergyNetworkPacketPayload;
import com.mrh0.createaddition.network.IObserveBlockEntity;
import com.mrh0.createaddition.network.ObservePacketPayload;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RedstoneRelayBlockEntity
extends SmartBlockEntity
implements IWireNode,
IHaveGoggleInformation,
IObserveBlockEntity {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes = new LocalNode[this.getNodeCount()];
    private final IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;
    private int demand = 0;
    private int throughput = 0;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    public static Vec3 OFFSET_NORTH = new Vec3(0.0, -0.0625, -0.3125);
    public static Vec3 OFFSET_WEST = new Vec3(-0.3125, -0.0625, 0.0);
    public static Vec3 OFFSET_SOUTH = new Vec3(0.0, -0.0625, 0.3125);
    public static Vec3 OFFSET_EAST = new Vec3(0.3125, -0.0625, 0.0);
    public static Vec3 IN_VERTICAL_OFFSET_NORTH = new Vec3(0.3125, 0.0, -0.0625);
    public static Vec3 IN_VERTICAL_OFFSET_WEST = new Vec3(-0.0625, 0.0, -0.3125);
    public static Vec3 IN_VERTICAL_OFFSET_SOUTH = new Vec3(-0.3125, 0.0, 0.0625);
    public static Vec3 IN_VERTICAL_OFFSET_EAST = new Vec3(0.0625, 0.0, 0.3125);
    public static Vec3 OUT_VERTICAL_OFFSET_NORTH = new Vec3(-0.3125, 0.0, -0.0625);
    public static Vec3 OUT_VERTICAL_OFFSET_WEST = new Vec3(-0.0625, 0.0, 0.3125);
    public static Vec3 OUT_VERTICAL_OFFSET_SOUTH = new Vec3(0.3125, 0.0, 0.0625);
    public static Vec3 OUT_VERTICAL_OFFSET_EAST = new Vec3(0.0625, 0.0, -0.3125);
    public static final int NODE_COUNT = 8;

    public RedstoneRelayBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.level);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public void setNode(int index, int other, BlockPos pos, WireType type) {
        this.localNodes[index] = new LocalNode((BlockEntity)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    @Override
    public Vec3 getNodeOffset(int node) {
        boolean vertical = (Boolean)this.getBlockState().getValue((Property)RedstoneRelayBlock.VERTICAL);
        Direction direction = (Direction)this.getBlockState().getValue((Property)RedstoneRelayBlock.HORIZONTAL_FACING);
        if (node > 3) {
            return switch (direction) {
                case Direction.NORTH -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_NORTH;
                    }
                    yield OFFSET_NORTH;
                }
                case Direction.WEST -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_WEST;
                    }
                    yield OFFSET_WEST;
                }
                case Direction.SOUTH -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_SOUTH;
                    }
                    yield OFFSET_SOUTH;
                }
                case Direction.EAST -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_EAST;
                    }
                    yield OFFSET_EAST;
                }
                default -> OFFSET_NORTH;
            };
        }
        return switch (direction) {
            case Direction.NORTH -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_NORTH;
                }
                yield OFFSET_SOUTH;
            }
            case Direction.WEST -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_WEST;
                }
                yield OFFSET_EAST;
            }
            case Direction.SOUTH -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_SOUTH;
                }
                yield OFFSET_NORTH;
            }
            case Direction.EAST -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_EAST;
                }
                yield OFFSET_WEST;
            }
            default -> OFFSET_NORTH;
        };
    }

    @Override
    public int getAvailableNode(Vec3 pos) {
        Direction dir = (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)RedstoneRelayBlock.HORIZONTAL_FACING);
        boolean vertical = (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)RedstoneRelayBlock.VERTICAL);
        boolean upper = true;
        pos = pos.subtract((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
        if (vertical) {
            switch (dir) {
                case NORTH: {
                    upper = pos.x() < 0.5;
                    break;
                }
                case WEST: {
                    upper = pos.z() > 0.5;
                    break;
                }
                case SOUTH: {
                    upper = pos.x() > 0.5;
                    break;
                }
                case EAST: {
                    upper = pos.z() < 0.5;
                    break;
                }
            }
        } else {
            switch (dir) {
                case NORTH: {
                    upper = pos.z() < 0.5;
                    break;
                }
                case WEST: {
                    upper = pos.x() < 0.5;
                    break;
                }
                case SOUTH: {
                    upper = pos.z() > 0.5;
                    break;
                }
                case EAST: {
                    upper = pos.x() > 0.5;
                    break;
                }
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public BlockPos getPos() {
        return this.getBlockPos();
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (!clientPacket && tag.contains("node0")) {
            this.convertOldNbt(tag);
            this.setChanged();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        ListTag nodes = tag.getList("nodes", 10);
        nodes.forEach(itag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((BlockEntity)this, (CompoundTag)itag);
        });
        if (tag.contains("contraption") && !clientPacket) {
            this.wasContraption = tag.getBoolean("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.getBlockState().getValue(NodeRotation.ROTATION));
            if (rotation != NodeRotation.NONE) {
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.networkIn != null && this.networkOut != null) {
            this.networkIn.invalidate();
            this.networkOut.invalidate();
        }
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        ListTag nodes = new ListTag();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            CompoundTag newTag = new CompoundTag();
            localNode.write(newTag);
            nodes.add((Object)newTag);
        }
        tag.put("nodes", (Tag)nodes);
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.networkIn != null) {
                this.networkIn.invalidate();
            }
            if (this.networkOut != null) {
                this.networkOut.invalidate();
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.firstTick) {
            this.firstTick = false;
            if (this.wasContraption && !this.level.isClientSide()) {
                this.wasContraption = false;
                this.validateNodes();
            }
        }
        if (!this.wireCache.isEmpty() && !this.isRemoved()) {
            this.handleWireCache(this.level, this.wireCache);
        }
        if (this.level.isClientSide()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        if (this.awakeNetwork(this.level)) {
            this.notifyUpdate();
        }
        BlockState bs = this.getBlockState();
        this.throughput = 0;
        if (!bs.is((Block)CABlocks.REDSTONE_RELAY.get())) {
            return;
        }
        if (((Boolean)bs.getValue((Property)RedstoneRelayBlock.POWERED)).booleanValue()) {
            this.throughput = this.networkOut.push(this.networkIn.pull(this.demand));
            this.demand = this.networkIn.demand(this.networkOut.getDemand());
        }
    }

    public int getThroughput() {
        return this.throughput;
    }

    public void remove() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    @Override
    public boolean isNodeIndeciesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    @Override
    public ConnectorType getConnectorType() {
        return ConnectorType.Small;
    }

    public int getDemand() {
        return this.demand;
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacketPayload pack) {
        if (this.isNetworkValid(pack.node())) {
            EnergyNetworkPacketPayload.send(this.worldPosition, this.getNetwork(pack.node()).getPulled(), this.getNetwork(pack.node()).getPushed(), player);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HitResult ray = Minecraft.getInstance().hitResult;
        if (ray == null) {
            return false;
        }
        int node = this.getAvailableNode(ray.getLocation());
        ObservePacketPayload.send(this.worldPosition, node);
        String spacing = " ";
        tooltip.add((Component)Component.literal((String)spacing).append((Component)Component.translatable((String)"createaddition.tooltip.relay.info").withStyle(ChatFormatting.WHITE)));
        tooltip.add((Component)Component.literal((String)spacing).append((Component)Component.translatable((String)"createaddition.tooltip.energy.selected").withStyle(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.literal((String)spacing).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)(this.isNodeInput(node) ? "createaddition.tooltip.energy.push" : "createaddition.tooltip.energy.pull")).withStyle(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.literal((String)spacing).append((Component)Component.translatable((String)"createaddition.tooltip.energy.usage").withStyle(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.literal((String)spacing).append(" ").append(Util.format(EnergyNetworkPacketPayload.clientBuff)).append("\u26a1/t").withStyle(ChatFormatting.AQUA));
        return true;
    }

    @Override
    public int getMaxWireLength() {
        return (Integer)CommonConfig.SMALL_CONNECTOR_MAX_LENGTH.get();
    }
}

