/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.CAConnectivityHandler;
import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlock;
import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.debug.IDebugDrawer;
import com.mrh0.createaddition.energy.IMultiTileEnergyContainer;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.index.CALang;
import com.mrh0.createaddition.network.EnergyNetworkPacketPayload;
import com.mrh0.createaddition.network.IObserveBlockEntity;
import com.mrh0.createaddition.network.ObservePacketPayload;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ModularAccumulatorBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiTileEnergyContainer,
IObserveBlockEntity,
IDebugDrawer,
ThresholdSwitchObservable {
    protected InternalEnergyStorage energyCapability;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected int width = 1;
    protected int height = 1;
    protected boolean updateCapability = false;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private final EnumSet<Direction> invalidSides = EnumSet.allOf(Direction.class);
    private final EnumMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> cache = new EnumMap(Direction.class);
    public LerpedFloat gauge = LerpedFloat.linear();
    int lastEnergy = 0;
    int energyChangeTick = 0;

    public ModularAccumulatorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyCapability = this.createEnergyStorage();
        this.refreshCapability();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)CABlockEntities.MODULAR_ACCUMULATOR.get(), (be, context) -> {
            if (be.energyCapability == null) {
                be.refreshCapability();
            }
            return be.energyCapability;
        });
    }

    public void onChunkUnloaded() {
    }

    protected InternalEnergyStorage createEnergyStorage() {
        return new InternalEnergyStorage(ModularAccumulatorBlockEntity.getCapacityMultiplier(), (Integer)CommonConfig.ACCUMULATOR_MAX_INPUT.get(), (Integer)CommonConfig.ACCUMULATOR_MAX_OUTPUT.get());
    }

    public void updateCache() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        for (Direction side : Direction.values()) {
            this.cache.put(side, (BlockCapabilityCache<IEnergyStorage, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos().relative(side), (Object)side.getOpposite(), () -> !this.isRemoved(), () -> this.invalidSides.add(side)));
        }
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            return;
        }
        if (!this.level.isLoaded(this.getBlockPos())) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        CAConnectivityHandler.formMulti(this);
    }

    public void tick() {
        super.tick();
        if (!this.invalidSides.isEmpty()) {
            this.updateCache();
            this.invalidSides.clear();
        }
        this.tickOutput();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition) && this.worldPosition != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (!this.isController()) {
            return;
        }
        if (Math.abs(this.lastEnergy - this.energyCapability.getEnergyStored()) > 256) {
            this.lastEnergy = this.energyCapability.getEnergyStored();
            this.onEnergyChanged();
        }
        if (this.energyChangeTick > 0) {
            --this.energyChangeTick;
        }
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> this::tickAudio);
            this.gauge.tickChaser();
            float current = this.gauge.getValue(1.0f);
            if (current > 1.0f && Create.RANDOM.nextFloat() < 0.5f) {
                this.gauge.setValueNoUpdate((double)(current + Math.min(-(current - 1.0f) * Create.RANDOM.nextFloat(), 0.0f)));
            }
        }
    }

    public void tickOutput() {
        if (this.getControllerBE() == null) {
            return;
        }
        BlockState state = this.getBlockState();
        if (((Boolean)state.getValue((Property)ModularAccumulatorBlock.TOP)).booleanValue()) {
            this.tickOutputSide(Direction.UP);
        }
        if (((Boolean)state.getValue((Property)ModularAccumulatorBlock.BOTTOM)).booleanValue()) {
            this.tickOutputSide(Direction.DOWN);
        }
    }

    public void tickOutputSide(Direction side) {
        if (this.level == null) {
            return;
        }
        if (!this.level.isLoaded(this.getBlockPos())) {
            return;
        }
        if (!this.level.isLoaded(this.getBlockPos().relative(side))) {
            return;
        }
        BlockCapabilityCache<IEnergyStorage, Direction> sideCache = this.cache.get(side);
        if (sideCache == null) {
            return;
        }
        IEnergyStorage ies = (IEnergyStorage)sideCache.getCapability();
        if (ies == null) {
            return;
        }
        int ext = this.getControllerBE().energyCapability.extractEnergy(ies.receiveEnergy(((Integer)CommonConfig.ACCUMULATOR_MAX_OUTPUT.get()).intValue(), true), false);
        int rec = ies.receiveEnergy(ext, false);
    }

    public void tickAudio() {
        if (this.energyChangeTick == 0) {
            return;
        }
        int sizeInBlocks = this.getTotalAccumulatorSize();
        float pitch = 0.75f;
        if (sizeInBlocks < 4) {
            pitch = 1.25f;
        }
        if (sizeInBlocks < 9) {
            pitch = 1.0f;
        }
        CASoundScapes.play(CASoundScapes.AmbienceGroup.CHARGE, this.worldPosition, pitch);
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    protected void onEnergyChanged() {
        if (this.level == null) {
            return;
        }
        if (!this.level.isLoaded(this.getBlockPos())) {
            return;
        }
        if (!this.hasLevel()) {
            return;
        }
        this.energyChangeTick = 20;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    if (!this.level.isLoaded(pos)) {
                        return;
                    }
                    ModularAccumulatorBlockEntity acc = (ModularAccumulatorBlockEntity)CAConnectivityHandler.partAt(this.getType(), (BlockGetter)this.level, pos);
                    if (acc == null) continue;
                    this.level.updateNeighbourForOutputSignal(pos, acc.getBlockState().getBlock());
                }
            }
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    @Nullable
    public ModularAccumulatorBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        if (this.level == null) {
            return this;
        }
        if (!this.level.isLoaded(this.getBlockPos())) {
            return this;
        }
        BlockEntity tileEntity = this.level.getBlockEntity(this.controller);
        if (tileEntity instanceof ModularAccumulatorBlockEntity) {
            return (ModularAccumulatorBlockEntity)tileEntity;
        }
        return null;
    }

    public void applySize(int blocks) {
        this.energyCapability.setCapacity(blocks * ModularAccumulatorBlockEntity.getCapacityMultiplier());
        int overflow = this.energyCapability.getEnergyStored() - this.energyCapability.getMaxEnergyStored();
        if (overflow > 0) {
            this.energyCapability.extractEnergy(overflow, false);
        }
    }

    public void removeController(boolean keepEnergy) {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            return;
        }
        if (!this.level.isLoaded(this.getBlockPos())) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepEnergy) {
            this.applySize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onEnergyChanged();
        BlockState state = this.getBlockState();
        if (ModularAccumulatorBlock.isAccumulator(state)) {
            state = (BlockState)state.setValue((Property)ModularAccumulatorBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue((Property)ModularAccumulatorBlock.TOP, (Comparable)Boolean.valueOf(true));
            this.getLevel().setBlock(this.worldPosition, state, 22);
        }
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(BlockPos controller) {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    void refreshCapability() {
        this.energyCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    private InternalEnergyStorage handlerForCapability() {
        return this.isController() ? this.energyCapability : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new InternalEnergyStorage(0, (Integer)CommonConfig.ACCUMULATOR_MAX_INPUT.get(), (Integer)CommonConfig.ACCUMULATOR_MAX_OUTPUT.get()));
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().expandTowards((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(tag, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = tag.contains("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (tag.contains("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"LastKnownPos").orElse(BlockPos.ZERO);
        }
        if (tag.contains("Controller")) {
            this.controller = NbtUtils.readBlockPos((CompoundTag)tag, (String)"Controller").orElse(BlockPos.ZERO);
        }
        if (this.isController()) {
            this.width = tag.getInt("Size");
            this.height = tag.getInt("Height");
            this.energyCapability.setCapacity(this.getTotalAccumulatorSize() * ModularAccumulatorBlockEntity.getCapacityMultiplier());
            this.energyCapability.read(tag.getCompound("EnergyContent"));
            if (this.energyCapability.getSpace() < 0) {
                this.energyCapability.extractEnergy(-this.energyCapability.getSpace(), true);
            }
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.energyCapability.setCapacity(ModularAccumulatorBlockEntity.getCapacityMultiplier() * this.getTotalAccumulatorSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            this.gauge.chase((double)this.getFillState(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public float getFillState() {
        return (float)this.energyCapability.getEnergyStored() / (float)this.energyCapability.getMaxEnergyStored();
    }

    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.updateConnectivity) {
            tag.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            tag.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            tag.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            tag.put("EnergyContent", (Tag)this.energyCapability.write(new CompoundTag()));
            tag.putInt("EnergyCapacity", this.getTotalAccumulatorSize() * ModularAccumulatorBlockEntity.getCapacityMultiplier());
            tag.putInt("Size", this.width);
            tag.putInt("Height", this.height);
        }
        super.writeSafe(tag, registries);
        if (!clientPacket) {
            return;
        }
        if (this.queuedSync) {
            tag.putBoolean("LazySync", true);
        }
    }

    public int getTotalAccumulatorSize() {
        return this.width * this.width * this.height;
    }

    public static int getCapacityMultiplier() {
        return (Integer)CommonConfig.ACCUMULATOR_CAPACITY.get();
    }

    public static int getMaxHeight() {
        return (Integer)CommonConfig.ACCUMULATOR_MAX_HEIGHT.get();
    }

    public int getMaxWidth() {
        return (Integer)CommonConfig.ACCUMULATOR_MAX_WIDTH.get();
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.getBlockState();
        if (ModularAccumulatorBlock.isAccumulator(state)) {
            state = (BlockState)state.setValue((Property)ModularAccumulatorBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().getY() == this.getBlockPos().getY()));
            state = (BlockState)state.setValue((Property)ModularAccumulatorBlock.TOP, (Comparable)Boolean.valueOf(this.getController().getY() + this.height - 1 == this.getBlockPos().getY()));
            if (this.level == null) {
                return;
            }
            this.level.setBlock(this.getBlockPos(), state, 7);
        }
        this.setChanged();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return ModularAccumulatorBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ModularAccumulatorBlockEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            return false;
        }
        ObservePacketPayload.send(this.worldPosition, 0);
        CALang.builder().add(Component.translatable((String)"createaddition.tooltip.accumulator.info").withStyle(ChatFormatting.WHITE)).forGoggles(tooltip);
        CALang.builder().add(Component.translatable((String)"createaddition.tooltip.energy.stored").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
        CALang.builder().add(Component.literal((String)" ").append(Util.format(EnergyNetworkPacketPayload.clientBuff)).append("\u26a1").withStyle(ChatFormatting.AQUA)).forGoggles(tooltip);
        CALang.builder().add(Component.translatable((String)"createaddition.tooltip.energy.capacity").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
        CALang.builder().add(Component.literal((String)" ").append(Util.format(controllerTE.energyCapability.getMaxEnergyStored())).append("\u26a1").withStyle(ChatFormatting.AQUA)).forGoggles(tooltip);
        return true;
    }

    public void observe() {
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacketPayload pack) {
        ModularAccumulatorBlockEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            return;
        }
        EnergyNetworkPacketPayload.send(this.worldPosition, 0, controllerTE.energyCapability.getEnergyStored(), player);
    }

    public boolean hasAccumulator() {
        return true;
    }

    public int getSize(int accumulator) {
        return ModularAccumulatorBlockEntity.getCapacityMultiplier();
    }

    public void setSize(int accumulator, int blocks) {
        this.applySize(blocks);
    }

    public InternalEnergyStorage getEnergy() {
        return this.energyCapability;
    }

    @Override
    public void drawDebug() {
        if (this.level == null) {
            return;
        }
        ModularAccumulatorBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return;
        }
        VoxelShape shape = this.level.getBlockState(controller.getBlockPos()).getBlockSupportShape((BlockGetter)this.level, controller.getBlockPos());
        Outliner.getInstance().chaseAABB((Object)"ca_accumulator", shape.bounds().move(controller.getBlockPos())).lineWidth(0.0625f).colored(0xFF5B5B);
    }

    public int getMaxValue() {
        return 100;
    }

    public int getMinValue() {
        return 0;
    }

    public int getCurrentValue() {
        ModularAccumulatorBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return 0;
        }
        return (int)((float)controllerBE.energyCapability.getEnergyStored() / (float)controllerBE.energyCapability.getMaxEnergyStored() * 100.0f);
    }

    public MutableComponent format(int i) {
        return Component.literal((String)(i + "%"));
    }
}

