/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.compat.minecraft;

import com.teamresourceful.resourcefulconfig.api.patching.ConfigPatchEvent;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigButton;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.info.ResourcefulConfigInfo;
import com.teamresourceful.resourcefulconfig.common.compat.minecraft.DedicatedServerEntry;
import com.teamresourceful.resourcefulconfig.common.compat.minecraft.DedicatedServerInfo;
import com.teamresourceful.resourcefulconfig.mixins.common.PlayerListAccessor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class DedicatedServerConfig
implements ResourcefulConfig {
    public static final DedicatedServerConfig INSTANCE = new DedicatedServerConfig();
    private static final LinkedHashMap<String, ResourcefulConfigEntry> ENTRIES = (LinkedHashMap)Util.make(new LinkedHashMap(), entries -> {
        entries.put("pvp", new DedicatedServerEntry("pvp", true, MinecraftServer::setPvpAllowed));
        entries.put("allow-flight", new DedicatedServerEntry("allow-flight", false, MinecraftServer::setFlightAllowed));
        entries.put("motd", new DedicatedServerEntry("motd", "A Minecraft Server", MinecraftServer::setMotd));
        entries.put("white-list", new DedicatedServerEntry("white-list", false, (server, value) -> {
            server.getPlayerList().setUsingWhiteList(value.booleanValue());
            server.kickUnlistedPlayers(server.createCommandSourceStack());
        }));
        entries.put("enforce-whitelist", new DedicatedServerEntry("enforce-whitelist", false, (server, value) -> {
            server.setEnforceWhitelist(value.booleanValue());
            server.kickUnlistedPlayers(server.createCommandSourceStack());
        }));
        entries.put("max-players", new DedicatedServerEntry("max-players", 20, (server, value) -> ((PlayerListAccessor)server.getPlayerList()).setMaxPlayers((int)value)));
    });
    private static final LinkedHashMap<String, ResourcefulConfig> CATEGORIES = new LinkedHashMap();

    @Override
    @NotNull
    public LinkedHashMap<String, ResourcefulConfigEntry> entries() {
        return ENTRIES;
    }

    @Override
    @NotNull
    public LinkedHashMap<String, ResourcefulConfig> categories() {
        return CATEGORIES;
    }

    @Override
    @NotNull
    public List<ResourcefulConfigButton> buttons() {
        return List.of();
    }

    @Override
    @NotNull
    public ResourcefulConfigInfo info() {
        return DedicatedServerInfo.INSTANCE;
    }

    @Override
    public String id() {
        return "minecraft/dedicated_server";
    }

    @Override
    public void save() {
    }

    @Override
    public void load(Consumer<ConfigPatchEvent> handler) {
    }

    @Override
    public boolean hasFile() {
        return false;
    }
}

