/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.Tools;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.common.util.Lazy;

public class ShieldTemplateBlock
extends Block
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}));
    private final TemplateColor color;

    public ShieldTemplateBlock(TemplateColor color) {
        super(BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.GLASS));
        this.color = color;
    }

    public TemplateColor getColor() {
        return this.color;
    }

    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Block)this), stack, tooltip, flagIn);
    }

    public static enum TemplateColor {
        BLUE,
        RED,
        GREEN,
        YELLOW;

    }
}

