/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class MoverControlBlock
extends BaseBlock {
    public static final DirectionProperty HORIZ_FACING = DirectionProperty.create((String)"horizfacing", (Predicate)Direction.Plane.HORIZONTAL);
    private final int page;

    public MoverControlBlock(int page) {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
        this.page = page;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)HORIZ_FACING, (Comparable)context.getPlayer().getDirection().getOpposite());
    }

    public int getPage() {
        return this.page;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction facing = (Direction)(state = super.rotate(state, rot)).getValue((Property)BlockStateProperties.FACING);
        if (facing.getStepY() == 0) {
            return (BlockState)state.setValue((Property)HORIZ_FACING, (Comparable)facing);
        }
        Direction horizFacing = (Direction)state.getValue((Property)HORIZ_FACING);
        return (BlockState)state.setValue((Property)HORIZ_FACING, (Comparable)rot.rotate(horizFacing));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HORIZ_FACING});
    }
}

