/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Rotation;

public class DirectionalBlockPos {
    public BlockPos position;
    public Direction direction;
    public Rotation rotation;

    public DirectionalBlockPos(int x, int y, int z, Direction direction) {
        this.position = new BlockPos(x, y, z);
        this.direction = direction;
    }

    public DirectionalBlockPos(int x, int y, int z, Direction direction, Rotation rotation) {
        this.position = new BlockPos(x, y, z);
        this.direction = direction;
        this.rotation = rotation;
    }

    public DirectionalBlockPos offset(Direction direction, int amount) {
        this.position = this.position.relative(direction, amount);
        return this;
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.putInt("x", this.position.getX());
        nbt.putInt("y", this.position.getY());
        nbt.putInt("z", this.position.getZ());
        nbt.putInt("direction", this.direction.get3DDataValue());
        if (this.rotation != null) {
            nbt.putString("rotation", this.rotation.toString().toUpperCase(Locale.ROOT));
        }
    }

    public static DirectionalBlockPos fromNBT(CompoundTag nbt) {
        return new DirectionalBlockPos(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z"), Direction.from3DDataValue((int)nbt.getInt("direction")), nbt.contains("rotation") ? Rotation.valueOf((String)nbt.getString("rotation")) : null);
    }
}

