/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure.function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;

public class SuspiciousStew
extends LootItemConditionalFunction {
    public static final MapCodec<SuspiciousStew> CODEC = RecordCodecBuilder.mapCodec(builder -> SuspiciousStew.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, SuspiciousStew::new));
    private static final SuspiciousStewEffects.Entry[] EFFECTS;

    public SuspiciousStew(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        stack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)SuspiciousStew.createEffectList(context.getRandom()));
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> suspiciousStew() {
        return SuspiciousStew.simpleBuilder(SuspiciousStew::new);
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)Loot.SUSPICIOUS_STEW.get();
    }

    public static SuspiciousStewEffects createEffectList(RandomSource rand) {
        int max = EFFECTS.length;
        ArrayList<SuspiciousStewEffects.Entry> effects = new ArrayList<SuspiciousStewEffects.Entry>();
        for (int counter = rand.nextInt(2); counter < max; counter += 1 + rand.nextInt(3)) {
            effects.add(EFFECTS[counter]);
        }
        return new SuspiciousStewEffects(effects);
    }

    static {
        SuspiciousStewEffects.Entry regeneration = new SuspiciousStewEffects.Entry(MobEffects.REGENERATION, 160);
        SuspiciousStewEffects.Entry weakness = new SuspiciousStewEffects.Entry(MobEffects.WEAKNESS, 320);
        SuspiciousStewEffects.Entry poison = new SuspiciousStewEffects.Entry(MobEffects.POISON, 160);
        SuspiciousStewEffects.Entry healthBoost = new SuspiciousStewEffects.Entry(MobEffects.HEALTH_BOOST, 320);
        SuspiciousStewEffects.Entry blindness = new SuspiciousStewEffects.Entry(MobEffects.BLINDNESS, 120);
        SuspiciousStewEffects.Entry resistance = new SuspiciousStewEffects.Entry(MobEffects.DAMAGE_RESISTANCE, 320);
        SuspiciousStewEffects.Entry nausea = new SuspiciousStewEffects.Entry(MobEffects.CONFUSION, 120);
        SuspiciousStewEffects.Entry absorption = new SuspiciousStewEffects.Entry(MobEffects.ABSORPTION, 320);
        SuspiciousStewEffects.Entry hunger = new SuspiciousStewEffects.Entry(MobEffects.HUNGER, 200);
        SuspiciousStewEffects.Entry saturation = new SuspiciousStewEffects.Entry(MobEffects.SATURATION, 80);
        SuspiciousStewEffects.Entry fireResistance = new SuspiciousStewEffects.Entry(MobEffects.FIRE_RESISTANCE, 320);
        SuspiciousStewEffects.Entry strength = new SuspiciousStewEffects.Entry(MobEffects.DAMAGE_BOOST, 320);
        SuspiciousStewEffects.Entry speed = new SuspiciousStewEffects.Entry(MobEffects.MOVEMENT_SPEED, 220);
        SuspiciousStewEffects.Entry slowness = new SuspiciousStewEffects.Entry(MobEffects.MOVEMENT_SLOWDOWN, 160);
        SuspiciousStewEffects.Entry miningFatigue = new SuspiciousStewEffects.Entry(MobEffects.DIG_SLOWDOWN, 160);
        SuspiciousStewEffects.Entry haste = new SuspiciousStewEffects.Entry(MobEffects.DIG_SPEED, 320);
        SuspiciousStewEffects.Entry jumpBoost = new SuspiciousStewEffects.Entry(MobEffects.JUMP, 160);
        SuspiciousStewEffects.Entry wither = new SuspiciousStewEffects.Entry(MobEffects.WITHER, 80);
        EFFECTS = new SuspiciousStewEffects.Entry[]{regeneration, weakness, poison, healthBoost, blindness, resistance, nausea, absorption, hunger, saturation, fireResistance, strength, speed, slowness, miningFatigue, haste, jumpBoost, wither};
    }
}

