/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.FluidState;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.PillarGenerator;
import xiroc.dungeoncrawl.dungeon.PlacementConfiguration;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelFeature;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.model.MultipartModelData;
import xiroc.dungeoncrawl.dungeon.model.PlacementBehaviour;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;

public abstract class DungeonPiece
extends StructurePiece {
    private static final BoundingBox EMPTY_BOX = new BoundingBox(0, 0, 0, 0, 0, 0);
    public static final int CORRIDOR = 0;
    public static final int STAIRS = 1;
    public static final int ENTRANCE = 6;
    public static final int ROOM = 8;
    public static final int SIDE_ROOM = 9;
    public static final int NODE_ROOM = 10;
    public static final int NODE_CONNECTOR = 11;
    public static final int MEGA_NODE_PART = 12;
    public static final int SECRET_ROOM = 14;
    public static final int SPIDER_ROOM = 15;
    public static final int MULTIPART_PIECE = 16;
    public Rotation rotation;
    public int connectedSides;
    public int x;
    public int y;
    public int z;
    public int stage;
    public boolean[] sides = new boolean[4];
    @Nullable
    public DungeonModelFeature.Instance[] features;
    public byte[] variation;
    public DungeonModel model;
    public Theme theme;
    public SecondaryTheme secondaryTheme;
    public Position2D gridPosition;

    public DungeonPiece(StructurePieceType p_i51343_1_) {
        super(p_i51343_1_, 0, EMPTY_BOX);
        this.connectedSides = 0;
        this.rotation = Rotation.NONE;
        this.gridPosition = new Position2D(0, 0);
    }

    public DungeonPiece(StructurePieceType p_i51343_1_, CompoundTag p_i51343_2_) {
        super(p_i51343_1_, p_i51343_2_);
        this.sides[0] = p_i51343_2_.getBoolean("north");
        this.sides[1] = p_i51343_2_.getBoolean("east");
        this.sides[2] = p_i51343_2_.getBoolean("south");
        this.sides[3] = p_i51343_2_.getBoolean("west");
        this.connectedSides = p_i51343_2_.getInt("connectedSides");
        this.gridPosition = new Position2D(p_i51343_2_.getInt("posX"), p_i51343_2_.getInt("posZ"));
        this.x = p_i51343_2_.getInt("x");
        this.y = p_i51343_2_.getInt("y");
        this.z = p_i51343_2_.getInt("z");
        this.stage = p_i51343_2_.getInt("stage");
        this.rotation = Orientation.getRotation(p_i51343_2_.getInt("rotation"));
        this.theme = p_i51343_2_.contains("theme", 99) ? Theme.getThemeByID(p_i51343_2_.getInt("theme")) : Theme.getTheme(ResourceLocation.parse((String)p_i51343_2_.getString("theme")));
        this.secondaryTheme = p_i51343_2_.contains("subTheme", 99) ? Theme.getSecondaryThemeByID(p_i51343_2_.getInt("subTheme")) : Theme.getSecondaryTheme(ResourceLocation.parse((String)p_i51343_2_.getString("secondaryTheme")));
        this.model = p_i51343_2_.contains("model", 99) ? DungeonModels.ID_TO_MODEL.get(p_i51343_2_.getInt("model")) : DungeonModels.KEY_TO_MODEL.get(ResourceLocation.parse((String)p_i51343_2_.getString("model")));
        if (p_i51343_2_.contains("features", 9)) {
            this.features = DungeonPiece.readAllFeatures(p_i51343_2_.getList("features", 10));
        }
        if (p_i51343_2_.contains("variation")) {
            this.variation = p_i51343_2_.getByteArray("variation");
        }
        this.createBoundingBox();
    }

    public void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        tagCompound.putBoolean("north", this.sides[0]);
        tagCompound.putBoolean("east", this.sides[1]);
        tagCompound.putBoolean("south", this.sides[2]);
        tagCompound.putBoolean("west", this.sides[3]);
        tagCompound.putInt("connectedSides", this.connectedSides);
        tagCompound.putInt("posX", this.gridPosition.x);
        tagCompound.putInt("posZ", this.gridPosition.z);
        tagCompound.putInt("x", this.x);
        tagCompound.putInt("y", this.y);
        tagCompound.putInt("z", this.z);
        tagCompound.putInt("stage", this.stage);
        tagCompound.putInt("rotation", Orientation.rotationAsInt(this.rotation));
        if (this.model != null) {
            tagCompound.putString("model", this.model.getKey().toString());
        }
        if (this.theme != null) {
            tagCompound.putString("theme", this.theme.getKey().toString());
        }
        if (this.secondaryTheme != null) {
            tagCompound.putString("secondaryTheme", this.secondaryTheme.getKey().toString());
        }
        if (this.features != null) {
            ListTag list = new ListTag();
            DungeonPiece.writeAllFeatures(this.features, list);
            tagCompound.put("features", (Tag)list);
        }
        if (this.variation != null) {
            tagCompound.putByteArray("variation", this.variation);
        }
    }

    public abstract int getDungeonPieceType();

    public abstract void setupModel(DungeonBuilder var1, ModelSelector var2, List<DungeonPiece> var3, RandomSource var4);

    public void createBoundingBox() {
        if (this.model != null) {
            this.boundingBox = this.model.createBoundingBoxWithOffset(this.x, this.y, this.z, this.rotation);
        }
    }

    public void openSide(Direction side) {
        switch (side) {
            case NORTH: {
                if (this.sides[0]) {
                    return;
                }
                this.sides[0] = true;
                ++this.connectedSides;
                break;
            }
            case EAST: {
                if (this.sides[1]) {
                    return;
                }
                this.sides[1] = true;
                ++this.connectedSides;
                break;
            }
            case SOUTH: {
                if (this.sides[2]) {
                    return;
                }
                this.sides[2] = true;
                ++this.connectedSides;
                break;
            }
            case WEST: {
                if (this.sides[3]) {
                    return;
                }
                this.sides[3] = true;
                ++this.connectedSides;
            }
        }
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setGridPosition(int x, int z) {
        this.gridPosition = new Position2D(x, z);
    }

    public void setGridPosition(Position2D position) {
        this.gridPosition = position;
    }

    public void setWorldPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setup(RandomSource rand) {
        if (this.model == null) {
            return;
        }
        if (this.model.hasFeatures()) {
            Vec3i offset = this.model.getOffset(this.rotation);
            ArrayList<DungeonModelFeature.Instance> features = new ArrayList<DungeonModelFeature.Instance>();
            for (DungeonModelFeature feature : this.model.getFeatures()) {
                feature.setup(this.model, this.x + offset.getX(), this.y + offset.getY(), this.z + offset.getZ(), this.rotation, features, rand);
            }
            this.features = features.toArray(new DungeonModelFeature.Instance[0]);
        }
        if (this.model.isVariationEnabled()) {
            this.variation = new byte[8];
            for (int i = 0; i < this.variation.length; ++i) {
                this.variation[i] = (byte)rand.nextInt(64);
            }
        }
    }

    protected boolean hasPillarAt(BlockPos pos) {
        return false;
    }

    public void takeOverProperties(DungeonPiece piece) {
        this.sides = piece.sides;
        this.connectedSides = piece.connectedSides;
        this.rotation = piece.rotation;
    }

    public boolean hasChildPieces() {
        return this.model != null && this.model.hasMultipart();
    }

    public void addChildPieces(List<DungeonPiece> pieces, DungeonBuilder builder, DungeonType type, ModelSelector modelSelector, int layer, RandomSource rand) {
        if (this.model != null && (this.model.hasMultipart() || type.getLayer(layer).hasMultipartOverride(this.model))) {
            BlockPos pos = new BlockPos(this.x, this.y, this.z).offset(this.model.getOffset(this.rotation));
            for (MultipartModelData data : type.getLayer(layer).getMultipartData(this.model)) {
                if (data.checkConditions(this)) {
                    pieces.add(data.models.roll(rand).createMultipartPiece(this, this.model, this.rotation, pos.getX(), pos.getY(), pos.getZ(), rand));
                    continue;
                }
                if (data.alternatives == null) continue;
                pieces.add(data.alternatives.roll(rand).createMultipartPiece(this, this.model, this.rotation, pos.getX(), pos.getY(), pos.getZ(), rand));
            }
        }
    }

    public void buildModel(DungeonModel model, LevelAccessor world, BoundingBox boundsIn, BlockPos pos, RandomSource random, PlacementConfiguration configuration, Theme theme, SecondaryTheme secondaryTheme, int lootLevel, Rotation rotation, boolean fillAir, boolean expandDownwards) {
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Building {} with rotation {} at ({} | {} | {})", (Object)model.getKey(), (Object)rotation, (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
        }
        ArrayList fancyPillars = new ArrayList(4);
        model.blocks.forEach(block -> {
            BlockPos position = block.worldPos(model, rotation, pos);
            if (boundsIn.isInside((Vec3i)position)) {
                BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, rotation, world, position, theme, secondaryTheme, world.getRandom(), this.variation, this.stage);
                this.placeBlock(world, state, position, (DungeonModelBlock)block, rotation, random, configuration, theme, secondaryTheme, fancyPillars, lootLevel, fillAir, expandDownwards);
            }
        });
        fancyPillars.forEach(pillar -> PillarGenerator.generateFancyPillar(world, pillar, random, boundsIn, theme));
        fancyPillars.clear();
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Finished building {} with rotation {} at ({} | {} | {})", (Object)model.getKey(), (Object)rotation, (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
        }
    }

    public void placeBlock(LevelAccessor world, BlockState state, BlockPos position, DungeonModelBlock block, Rotation rotation, RandomSource random, PlacementConfiguration configuration, Theme theme, SecondaryTheme secondaryTheme, List<BlockPos> fancyPillars, int lootLevel, boolean fillAir, boolean expandDownwards) {
        FluidState fluidState;
        if (DungeonBuilder.isBlockProtected(world, position)) {
            return;
        }
        PlacementBehaviour placementBehaviour = block.type.placementBehaviourFromConfig.apply(configuration);
        if (world.isEmptyBlock(position) && !placementBehaviour.isSolid(world, position, rotation, world.getRandom())) {
            if (placementBehaviour.airBlock != null) {
                state = placementBehaviour.airBlock.apply(theme, secondaryTheme).get(world, position, random);
            } else if (!fillAir && !((Boolean)Config.SOLID.get()).booleanValue()) {
                return;
            }
        }
        IBlockPlacementHandler.getHandler(state.getBlock()).place(world, state, position, random, theme, secondaryTheme, lootLevel);
        BlockEntity tile = world.getBlockEntity(position);
        if (tile instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity randomizableContainerBlockEntity = (RandomizableContainerBlockEntity)tile;
            if (this.model.hasLootTable()) {
                Loot.setLoot(world, position, randomizableContainerBlockEntity, this.model.getLootTable(), theme, secondaryTheme, random);
            } else {
                Loot.setLoot(world, position, randomizableContainerBlockEntity, Loot.getLootTable(this.stage, random), theme, secondaryTheme, random);
            }
        }
        if (!(fluidState = world.getFluidState(position)).isEmpty()) {
            world.scheduleTick(position, fluidState.getType(), 0);
        }
        if (block.hasProperties || !state.getProperties().isEmpty()) {
            world.getChunk(position).markPosForPostprocessing(position);
        }
        if (expandDownwards) {
            if (block.type.isExpandable() && block.position.getY() == 0 && !world.getBlockState(position.below()).canOcclude()) {
                PillarGenerator.generateSimplePillar(world, position.below(), theme, random);
            }
        } else if (block.position.getY() == 0 && (block.type.isPillar() || this.hasPillarAt(position)) && !world.getBlockState(position.below()).canOcclude()) {
            fancyPillars.add(position.below());
        }
    }

    public void replaceBlockState(LevelAccessor worldIn, BlockState blockState, int x, int y, int z, BoundingBox bounds, boolean postProcessing) {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (bounds.isInside((Vec3i)blockPos)) {
            FluidState fluidstate;
            if (DungeonBuilder.isBlockProtected(worldIn, blockPos) || worldIn.isEmptyBlock(blockPos)) {
                return;
            }
            worldIn.setBlock(blockPos, blockState, 2);
            if (postProcessing) {
                worldIn.getChunk(blockPos).markPosForPostprocessing(blockPos);
            }
            if (!(fluidstate = worldIn.getFluidState(blockPos)).isEmpty()) {
                worldIn.scheduleTick(blockPos, fluidstate.getType(), 0);
            }
        }
    }

    protected void entrances(LevelAccessor world, BoundingBox bounds, DungeonModel model, RandomSource random) {
        BlockState stair2;
        BlockPos pos2;
        BlockState stair1;
        BlockPos pos1;
        BlockStateProvider stateProvider;
        int pathStartX = (model.width - 3) / 2;
        int pathStartZ = (model.length - 3) / 2;
        Vec3i offset = model.getOffset(this.rotation);
        BlockPos pos = new BlockPos(this.x + offset.getX(), this.y, this.z + offset.getZ());
        if (this.sides[0]) {
            for (int x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                this.replaceBlockState(world, CAVE_AIR, pos.getX() + x0, pos.getY() + 1, pos.getZ(), bounds, false);
                this.replaceBlockState(world, CAVE_AIR, pos.getX() + x0, pos.getY() + 2, pos.getZ(), bounds, false);
            }
            this.replaceBlockState(world, CAVE_AIR, pos.getX() + pathStartX + 1, pos.getY() + 3, pos.getZ(), bounds, false);
            stateProvider = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.getX() + pathStartX, pos.getY() + 3, pos.getZ());
            stair1 = stateProvider.get(world, pos1, random);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.HORIZONTAL_FACING, Direction.WEST);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.HALF, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.getX(), pos1.getY(), pos1.getZ(), bounds, false);
            pos2 = pos1.relative(Direction.EAST, 2);
            stair2 = stateProvider.get(world, pos2, random);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.HORIZONTAL_FACING, Direction.EAST);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.HALF, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.getX(), pos2.getY(), pos2.getZ(), bounds, false);
        }
        if (this.sides[1]) {
            for (int z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                this.replaceBlockState(world, CAVE_AIR, pos.getX() + model.width - 1, pos.getY() + 1, pos.getZ() + z0, bounds, false);
                this.replaceBlockState(world, CAVE_AIR, pos.getX() + model.width - 1, pos.getY() + 2, pos.getZ() + z0, bounds, false);
            }
            this.replaceBlockState(world, CAVE_AIR, pos.getX() + model.width - 1, pos.getY() + 3, pos.getZ() + pathStartZ + 1, bounds, false);
            stateProvider = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.getX() + model.width - 1, pos.getY() + 3, pos.getZ() + pathStartZ);
            stair1 = stateProvider.get(world, pos1, random);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.HORIZONTAL_FACING, Direction.NORTH);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.HALF, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.getX(), pos1.getY(), pos1.getZ(), bounds, false);
            pos2 = pos1.relative(Direction.SOUTH, 2);
            stair2 = stateProvider.get(world, pos2, random);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.HORIZONTAL_FACING, Direction.SOUTH);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.HALF, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.getX(), pos2.getY(), pos2.getZ(), bounds, false);
        }
        if (this.sides[2]) {
            for (int x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                this.replaceBlockState(world, CAVE_AIR, pos.getX() + x0, pos.getY() + 1, pos.getZ() + model.length - 1, bounds, false);
                this.replaceBlockState(world, CAVE_AIR, pos.getX() + x0, pos.getY() + 2, pos.getZ() + model.length - 1, bounds, false);
            }
            this.replaceBlockState(world, CAVE_AIR, pos.getX() + pathStartX + 1, pos.getY() + 3, pos.getZ() + model.length - 1, bounds, false);
            stateProvider = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.getX() + pathStartX, pos.getY() + 3, pos.getZ() + model.length - 1);
            stair1 = stateProvider.get(world, pos1, random);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.HORIZONTAL_FACING, Direction.WEST);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.HALF, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.getX(), pos1.getY(), pos1.getZ(), bounds, false);
            pos2 = pos1.relative(Direction.EAST, 2);
            stair2 = stateProvider.get(world, pos2, random);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.HORIZONTAL_FACING, Direction.EAST);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.HALF, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.getX(), pos2.getY(), pos2.getZ(), bounds, false);
        }
        if (this.sides[3]) {
            for (int z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                this.replaceBlockState(world, CAVE_AIR, pos.getX(), pos.getY() + 1, pos.getZ() + z0, bounds, false);
                this.replaceBlockState(world, CAVE_AIR, pos.getX(), pos.getY() + 2, pos.getZ() + z0, bounds, false);
            }
            this.replaceBlockState(world, CAVE_AIR, pos.getX(), pos.getY() + 3, pos.getZ() + pathStartZ + 1, bounds, false);
            BlockStateProvider stateProvider2 = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.getX(), pos.getY() + 3, pos.getZ() + pathStartZ);
            stair1 = stateProvider2.get(world, pos1, random);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.HORIZONTAL_FACING, Direction.NORTH);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.HALF, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.getX(), pos1.getY(), pos1.getZ(), bounds, false);
            pos2 = pos1.relative(Direction.SOUTH, 2);
            stair2 = stateProvider2.get(world, pos2, random);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.HORIZONTAL_FACING, Direction.SOUTH);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.HALF, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.getX(), pos2.getY(), pos2.getZ(), bounds, false);
        }
    }

    protected void decorate(LevelAccessor world, BlockPos pos, Theme theme, RandomSource random, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonModel model) {
        if (theme.hasDecorations()) {
            for (DungeonDecoration decoration : theme.getDecorations()) {
                if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                    DungeonCrawl.LOGGER.debug("Running decoration {} for {} at ({} | {} | {})", (Object)decoration.toString(), (Object)model.getKey(), (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
                }
                decoration.decorate(model, world, pos, random, worldGenBounds, structureBounds, this);
                if (!((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) continue;
                DungeonCrawl.LOGGER.debug("Finished decoration {} for {} at ({} | {} | {})", (Object)decoration.toString(), (Object)model.getKey(), (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
            }
        }
    }

    protected void placeFeatures(LevelAccessor world, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, RandomSource rand, int stage) {
        if (this.features != null) {
            for (DungeonModelFeature.Instance feature : this.features) {
                feature.place(world, bounds, rand, theme, secondaryTheme, stage);
            }
        }
    }

    public static Direction getOneWayDirection(DungeonPiece piece) {
        if (piece.sides[0]) {
            return Direction.NORTH;
        }
        if (piece.sides[1]) {
            return Direction.EAST;
        }
        if (piece.sides[2]) {
            return Direction.SOUTH;
        }
        if (piece.sides[3]) {
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    public boolean canConnect(Direction side, int x, int z) {
        return true;
    }

    public static Direction getOpenSide(DungeonPiece piece, int n) {
        int c = 0;
        for (int i = 0; i < 4; ++i) {
            if (!piece.sides[i] || c++ != n) continue;
            return DungeonPiece.getDirectionFromInt(i);
        }
        throw new IllegalStateException(String.valueOf((Object)piece) + " does not have " + n + "or more open sides.");
    }

    public static Direction getDirectionFromInt(int dir) {
        return switch (dir) {
            case 1 -> Direction.EAST;
            case 2 -> Direction.SOUTH;
            case 3 -> Direction.WEST;
            default -> Direction.NORTH;
        };
    }

    protected static ListTag positionsToNbt(BlockPos[] positions) {
        ListTag nbtPositions = new ListTag();
        for (BlockPos pillar : positions) {
            CompoundTag p = new CompoundTag();
            p.putInt("x", pillar.getX());
            p.putInt("y", pillar.getY());
            p.putInt("z", pillar.getZ());
            nbtPositions.add((Object)p);
        }
        return nbtPositions;
    }

    protected static BlockPos[] positionsFromNbt(ListTag nbt) {
        BlockPos[] positions = new BlockPos[nbt.size()];
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag pillar = nbt.getCompound(i);
            positions[i] = new BlockPos(pillar.getInt("x"), pillar.getInt("y"), pillar.getInt("z"));
        }
        return positions;
    }

    protected static DungeonModelFeature.Instance[] readAllFeatures(ListTag nbt) {
        DungeonModelFeature.Instance[] features = new DungeonModelFeature.Instance[nbt.size()];
        for (int i = 0; i < features.length; ++i) {
            features[i] = DungeonModelFeature.Instance.read(nbt.getCompound(i));
        }
        return features;
    }

    protected static void writeAllFeatures(DungeonModelFeature.Instance[] positions, ListTag nbt) {
        for (DungeonModelFeature.Instance feature : positions) {
            CompoundTag position = new CompoundTag();
            feature.write(position);
            nbt.add((Object)position);
        }
    }
}

