/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.config;

import java.util.Iterator;
import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec CONFIG;
    public static final ModConfigSpec.IntValue SPAWNER_ENTITIES;
    public static final ModConfigSpec.IntValue SPAWNER_RANGE;
    public static final ModConfigSpec.BooleanValue CUSTOM_SPAWNERS;
    public static final ModConfigSpec.BooleanValue NO_NETHER_STUFF;
    public static final ModConfigSpec.BooleanValue SOLID;
    public static final ModConfigSpec.BooleanValue NATURAL_DESPAWN;
    public static final ModConfigSpec.BooleanValue EXTENDED_DEBUG;
    public static final ModConfigSpec.BooleanValue TICK_FALLING_BLOCKS;
    public static final ModConfigSpec.BooleanValue OVERWRITE_ENTITY_LOOT_TABLES;
    public static final ModConfigSpec.BooleanValue SECRET_ROOMS;
    public static final ModConfigSpec.BooleanValue FIXED_GENERATION_HEIGHT;
    private static final String SEPARATOR_LINE = "----------------------------------------------------------------------------------------------------+\n";

    private static <T> String commaSeparated(Iterator<T> elements, Function<T, String> toString) {
        StringBuilder builder = new StringBuilder();
        while (elements.hasNext()) {
            builder.append(toString.apply(elements.next()));
            if (!elements.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    static {
        BUILDER.push("Miscellaneous Settings");
        EXTENDED_DEBUG = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Enables extended debug logging to help detecting errors. Enabled by default.\n").define("extended_debug", true);
        BUILDER.pop();
        BUILDER.push("World Generation");
        SOLID = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n When enabled, the dungeons will ignore caves instead of trying to adjust to them (by not generating specific blocks).\n").define("solid", false);
        TICK_FALLING_BLOCKS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether falling blocks like sand or gravel should drop down after being placed during dungeon generation.\n").define("tick_falling_blocks", true);
        BUILDER.pop();
        BUILDER.push("Dungeon Settings");
        SECRET_ROOMS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether the dungeons should have secret rooms or not.\n").define("secret_rooms", true);
        FIXED_GENERATION_HEIGHT = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n\nWhether the dungeons should generate at a fixed height or not. Enable this if the dungeons are generating too high.").define("fixed_generation_height", false);
        OVERWRITE_ENTITY_LOOT_TABLES = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether loot tables of certain spawner entities should be overwritten.\n For example, wither skeletons from dungeon spawners will never drop skulls if this is enabled.\n").define("overwrite_entity_loot_tables", true);
        NO_NETHER_STUFF = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether the hell stage should be built with blocks from the overworld instead from the nether.\n").define("no_nether_blocks", false);
        SPAWNER_RANGE = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n The activation range for the spawners in the dungeons.\n").defineInRange("spawner_activation_range", 12, 1, 64);
        SPAWNER_ENTITIES = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n The number of different entities per spawner. Increasing the number increases the diversity of the monster equipment.\n").defineInRange("spawner_entities", 6, 1, 128);
        CUSTOM_SPAWNERS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether custom mob spawners with equipment, etc.. should be used.\n").define("custom_spawners", true);
        NATURAL_DESPAWN = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether mobs from spawners should despawn naturally or not.\n").define("natural_despawn", true);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

