/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;

public class SpitfulLlamaModel<T extends AbstractChestedHorse>
extends LlamaModel<T> {
    private final ModelPart mouth;

    public SpitfulLlamaModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart head = modelPart.getChild("head");
        this.mouth = head.getChild("mouth");
    }

    public static LayerDefinition createAnimatedBodyLayer(CubeDeformation cubeDeformation) {
        LayerDefinition layerDefinition = LlamaModel.createBodyLayer((CubeDeformation)cubeDeformation);
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition1 = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -14.0f, -10.0f, 4.0f, 2.0f, 9.0f, cubeDeformation).texOffs(0, 14).addBox("neck", -4.0f, -16.0f, -6.0f, 8.0f, 18.0f, 6.0f, cubeDeformation).texOffs(17, 0).addBox("ear", -4.0f, -19.0f, -4.0f, 3.0f, 3.0f, 2.0f, cubeDeformation).texOffs(17, 0).addBox("ear", 1.0f, -19.0f, -4.0f, 3.0f, 3.0f, 2.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)7.0f, (float)-6.0f));
        partDefinition1.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 2).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 2.0f, 9.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-12.0f, (float)-6.0f));
        return layerDefinition;
    }

    public void prepareMobModel(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        int soundTime = ((AbstractChestedHorse)entitylivingbaseIn).ambientSoundTime + entitylivingbaseIn.getAmbientSoundInterval();
        if (0 < soundTime && soundTime < 5) {
            float rotation = Math.abs(Mth.sin((float)((float)soundTime * (float)Math.PI / 5.0f)));
            this.mouth.xRot = rotation * 0.75f;
        } else {
            this.mouth.xRot = 0.0f;
        }
    }
}

