/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.animal.Sheep;

public class KneelingSheepModel<T extends Sheep>
extends SheepModel<T> {
    private final ModelPart rightFrontLowerLeg;
    private final ModelPart leftFrontLowerLeg;

    public KneelingSheepModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart rightFrontLeg = modelPart.getChild("right_front_leg");
        this.rightFrontLowerLeg = rightFrontLeg.getChild("right_front_lower_leg");
        ModelPart leftFrontLeg = modelPart.getChild("left_front_leg");
        this.leftFrontLowerLeg = leftFrontLeg.getChild("left_front_lower_leg");
    }

    public static LayerDefinition createAnimatedBodyLayer() {
        LayerDefinition layerDefinition = SheepModel.createBodyLayer();
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 8).addBox(-4.0f, -15.0f, 0.0f, 8.0f, 16.0f, 6.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)7.0f));
        PartDefinition partDefinition1 = partDefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.offset((float)-3.0f, (float)12.0f, (float)-5.0f));
        PartDefinition partDefinition2 = partDefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f), PartPose.offset((float)3.0f, (float)12.0f, (float)-5.0f));
        CubeListBuilder cubeListBuilder = CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f).texOffs(0, 16).addBox(-2.0f, 5.02f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(-0.01f));
        PartPose partPose = PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f);
        partDefinition1.addOrReplaceChild("right_front_lower_leg", cubeListBuilder, partPose);
        partDefinition2.addOrReplaceChild("left_front_lower_leg", cubeListBuilder, partPose);
        return layerDefinition;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.body.xRot = 1.5707964f;
        float partialTicks = ageInTicks - (float)((Sheep)entityIn).tickCount;
        float rotation = entityIn.getHeadEatPositionScale(partialTicks);
        this.body.xRot += rotation * 0.4f;
        this.rightFrontLeg.y = this.leftFrontLeg.y = 12.0f + rotation * 4.0f;
        this.rightFrontLeg.xRot -= rotation;
        this.leftFrontLeg.xRot -= rotation;
        this.rightFrontLowerLeg.xRot = this.leftFrontLowerLeg.xRot = rotation * 2.0f;
    }
}

