/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.client.element.JigglySlimeElement;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Slime;

public class JigglySlimeModel<T extends Entity>
extends SlimeModel<T> {
    private final ModelPart cube;
    private final ModelPart rightEye;
    private final ModelPart leftEye;
    private final ModelPart mouth;
    private final boolean isSlimeGelLayer;

    public JigglySlimeModel(ModelPart modelPart) {
        super(modelPart);
        this.cube = modelPart.getChild("cube");
        boolean bl = this.isSlimeGelLayer = !modelPart.hasChild("mouth");
        if (!this.isSlimeGelLayer) {
            this.rightEye = modelPart.getChild("right_eye");
            this.leftEye = modelPart.getChild("left_eye");
            this.mouth = modelPart.getChild("mouth");
        } else {
            this.rightEye = null;
            this.leftEye = null;
            this.mouth = null;
        }
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn instanceof Slime) {
            Slime slime = (Slime)entityIn;
            float progress = limbSwing + ageInTicks * (float)JigglySlimeElement.animationSpeed / 15.0f;
            float magnitude = (float)JigglySlimeElement.animationSpeed / 20.0f;
            if (slime.targetSquish < 0.0f) {
                magnitude += -slime.targetSquish * 0.5f;
            }
            if (this.isSlimeGelLayer) {
                this.cube.x = Mth.sin((float)(progress * 0.3f)) * magnitude * 0.5f;
                this.cube.y = Mth.sin((float)(progress * 0.33f)) * magnitude * 0.5f;
                this.cube.z = Mth.sin((float)(progress * 0.375f)) * magnitude * 0.25f;
            } else {
                this.rightEye.x = Mth.sin((float)(progress * 0.5f + 0.5f)) * magnitude - 0.125f;
                this.rightEye.y = Mth.sin((float)(progress * 0.45f + 1.5f)) * magnitude;
                this.rightEye.z = Mth.sin((float)(progress * 0.475f + 2.5f)) * magnitude * 0.25f;
                this.leftEye.x = Mth.sin((float)(progress * 0.525f + 1.0f)) * magnitude + 0.125f;
                this.leftEye.y = Mth.sin((float)(progress * 0.475f + 3.0f)) * magnitude;
                this.leftEye.z = Mth.sin((float)(progress * 0.425f + 2.0f)) * magnitude * 0.25f;
                this.mouth.x = Mth.sin((float)(progress * 0.55f + 3.75f)) * magnitude;
                this.mouth.y = Mth.sin((float)(progress * 0.625f + 1.75f)) * magnitude;
                this.mouth.z = Mth.sin((float)(progress * 0.6f + 2.75f)) * magnitude * 0.25f;
                this.cube.x = Mth.sin((float)(progress * 0.4f)) * magnitude;
                this.cube.y = Mth.sin((float)(progress * 0.44f)) * magnitude;
                this.cube.z = Mth.sin((float)(progress * 0.475f)) * magnitude * 0.5f;
            }
        }
    }
}

