/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.ReprocessorPartType;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType2;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartTypeProvider;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelDataCache;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage;
import it.zerono.mods.zerocore.lib.energy.NullEnergyHandlers;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public abstract class AbstractReprocessorEntity
extends AbstractMultiblockEntity<MultiblockReprocessor>
implements IMultiblockPartTypeProvider<MultiblockReprocessor, ReprocessorPartType> {
    private static final CuboidPartVariantsModelDataCache s_modelDataCaches = new CuboidPartVariantsModelDataCache();

    public AbstractReprocessorEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    protected boolean isReprocessorActive() {
        return this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).map(MultiblockReprocessor::isMachineActive).orElse(false);
    }

    protected void setReprocessorActive(boolean active) {
        this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).ifPresent(c -> c.setMachineActive(active));
    }

    public IItemHandlerModifiable getItemInventory(IoDirection direction) {
        return (IItemHandlerModifiable)this.evalOnController(r -> r.getItemHandler(direction), ItemHelper.EMPTY_ITEM_HANDLER);
    }

    public IFluidHandler getFluidInventory() {
        return (IFluidHandler)this.evalOnController(MultiblockReprocessor::getFluidHandler, FluidHelper.EMPTY_FLUID_HANDLER);
    }

    public IWideEnergyStorage getEnergyStorage() {
        return (IWideEnergyStorage)this.evalOnController(MultiblockReprocessor::getEnergyStorage, NullEnergyHandlers.STORAGE);
    }

    public Component getPartDisplayName() {
        return Component.translatable((String)this.getPartType().map(IMultiblockPartType2::getTranslationKey).orElse("unknown"));
    }

    public boolean isValidIngredient(ItemStack stack) {
        return (Boolean)this.evalOnController(r -> r.isValidIngredient(stack), false);
    }

    public boolean isValidIngredient(FluidStack stack) {
        return (Boolean)this.evalOnController(r -> r.isValidIngredient(stack), false);
    }

    protected ModelData getUpdatedModelData() {
        return this.getPartType().map(this::getUpdatedModelData).orElse(ModelData.EMPTY);
    }

    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        messages.addUnlocalized("Model Variant Index: %d", new Object[]{this.getUpdatedModelVariantIndex()});
    }

    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (position.isFrame()) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reprocessor.invalid_frame_block", new Object[0]);
            return false;
        }
        if (PartPosition.Interior == position) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reprocessor.invalid_part_for_interior", new Object[0]);
            return false;
        }
        if (position.isFace()) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reprocessor.invalid_part_for_face", new Object[0]);
            return false;
        }
        return true;
    }

    public MultiblockReprocessor createController() {
        return new MultiblockReprocessor(Objects.requireNonNull(this.getLevel(), "Trying to create a Controller from a Part without a Level"));
    }

    public Class<MultiblockReprocessor> getControllerType() {
        return MultiblockReprocessor.class;
    }

    public void onMachineActivated() {
    }

    public void onMachineDeactivated() {
    }

    protected ModelData getUpdatedModelData(ReprocessorPartType partType) {
        return s_modelDataCaches.computeIfAbsent(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings());
    }
}

