/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.sand;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;

public class BWGSandSet {
    private static final ArrayList<BWGSandSet> sandSets = new ArrayList();
    private final String name;
    private final Supplier<ColoredFallingBlock> sand;
    private final Supplier<Block> sandstone;
    private final Supplier<SlabBlock> sandstoneSlab;
    private final Supplier<StairBlock> sandstoneStairs;
    private final Supplier<WallBlock> sandstoneWall;
    private final Supplier<Block> chiseledSandstone;
    private final Supplier<Block> smoothSandstone;
    private final Supplier<SlabBlock> smoothSandstoneSlab;
    private final Supplier<StairBlock> smoothSandstoneStairs;
    private final Supplier<Block> cutSandstone;
    private final Supplier<SlabBlock> cutSandstoneSlab;
    private final TagKey<Block> sandstoneBlocksTag;
    private final TagKey<Item> sandstoneBlocksItemTag;
    private final TagKey<Block> sandBlockTag;
    private final TagKey<Item> sandItemTag;
    private final TagKey<Block> sandstoneSlabsTag;
    private final TagKey<Item> sandstoneSlabsItemTag;
    private final TagKey<Block> sandstoneStairsTag;
    private final TagKey<Item> sandstoneStairsItemTag;

    public BWGSandSet(String name, int dustColor) {
        this.name = name;
        this.sand = BWGBlocks.registerCubeAllBlockItem(name + "_sand", () -> new ColoredFallingBlock(new ColorRGBA(dustColor), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND)));
        this.sandstone = BWGBlocks.registerBlockItem(name + "_sandstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE)));
        this.sandstoneSlab = BWGBlocks.registerBlockItem(name + "_sandstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE_SLAB)));
        this.sandstoneStairs = BWGBlocks.registerBlockItem(name + "_sandstone_stairs", () -> new StairBlock(this.sandstone.get().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE_STAIRS)));
        this.sandstoneWall = BWGBlocks.registerBlockItem(name + "_sandstone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE_WALL)));
        this.chiseledSandstone = BWGBlocks.registerBlockItem("chiseled_" + name + "_sandstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHISELED_SANDSTONE)));
        this.smoothSandstone = BWGBlocks.registerBlockItem("smooth_" + name + "_sandstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMOOTH_SANDSTONE)));
        this.smoothSandstoneSlab = BWGBlocks.registerBlockItem("smooth_" + name + "_sandstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMOOTH_SANDSTONE_SLAB)));
        this.smoothSandstoneStairs = BWGBlocks.registerBlockItem("smooth_" + name + "_sandstone_stairs", () -> new StairBlock(this.smoothSandstone.get().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMOOTH_SANDSTONE_STAIRS)));
        this.cutSandstone = BWGBlocks.registerBlockItem("cut_" + name + "_sandstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CUT_SANDSTONE)));
        this.cutSandstoneSlab = BWGBlocks.registerBlockItem("cut_" + name + "_sandstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CUT_SANDSTONE_SLAB)));
        this.sandstoneBlocksTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_blocks"));
        this.sandstoneBlocksItemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_blocks"));
        this.sandBlockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BiomesWeveGone.id("sand/" + name));
        this.sandItemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BiomesWeveGone.id("sand/" + name));
        this.sandstoneSlabsTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_slabs"));
        this.sandstoneSlabsItemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_slabs"));
        this.sandstoneStairsTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_stairs"));
        this.sandstoneStairsItemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BiomesWeveGone.id(name + "_sandstone_stairs"));
        sandSets.add(this);
    }

    public String getName() {
        return this.name;
    }

    public ColoredFallingBlock getSand() {
        return this.sand.get();
    }

    public Block getSandstone() {
        return this.sandstone.get();
    }

    public SlabBlock getSandstoneSlab() {
        return this.sandstoneSlab.get();
    }

    public StairBlock getSandstoneStairs() {
        return this.sandstoneStairs.get();
    }

    public WallBlock getSandstoneWall() {
        return this.sandstoneWall.get();
    }

    public Block getChiseledSandstone() {
        return this.chiseledSandstone.get();
    }

    public Block getSmoothSandstone() {
        return this.smoothSandstone.get();
    }

    public SlabBlock getSmoothSandstoneSlab() {
        return this.smoothSandstoneSlab.get();
    }

    public StairBlock getSmoothSandstoneStairs() {
        return this.smoothSandstoneStairs.get();
    }

    public Block getCutSandstone() {
        return this.cutSandstone.get();
    }

    public SlabBlock getCutSandstoneSlab() {
        return this.cutSandstoneSlab.get();
    }

    public TagKey<Block> getSandstoneBlocksTag() {
        return this.sandstoneBlocksTag;
    }

    public TagKey<Item> getSandstoneBlocksItemTag() {
        return this.sandstoneBlocksItemTag;
    }

    public TagKey<Block> getSandBlockTag() {
        return this.sandBlockTag;
    }

    public TagKey<Item> getSandItemTag() {
        return this.sandItemTag;
    }

    public TagKey<Block> getSandstoneSlabsTag() {
        return this.sandstoneSlabsTag;
    }

    public TagKey<Item> getSandstoneSlabsItemTag() {
        return this.sandstoneSlabsItemTag;
    }

    public TagKey<Block> getSandstoneStairsTag() {
        return this.sandstoneStairsTag;
    }

    public TagKey<Item> getSandstoneStairsItemTag() {
        return this.sandstoneStairsItemTag;
    }

    public BlockFamily getSandStoneFamily() {
        return BlockFamilies.familyBuilder((Block)this.getSandstone()).wall((Block)this.getSandstoneWall()).stairs((Block)this.getSandstoneStairs()).slab((Block)this.getSandstoneSlab()).chiseled(this.getChiseledSandstone()).cut(this.getCutSandstone()).dontGenerateRecipe().getFamily();
    }

    public BlockFamily getSmoothSandStoneFamily() {
        return BlockFamilies.familyBuilder((Block)this.getSmoothSandstone()).stairs((Block)this.getSmoothSandstoneStairs()).slab((Block)this.getSmoothSandstoneSlab()).getFamily();
    }

    public BlockFamily getCutSandStoneFamily() {
        return BlockFamilies.familyBuilder((Block)this.getCutSandstone()).slab((Block)this.getCutSandstoneSlab()).getFamily();
    }

    public static ArrayList<BWGSandSet> getSandSets() {
        return sandSets;
    }
}

