/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.MudBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.tags.BWGBlockTags;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.custom.BWGDirtPathBlock;
import net.potionstudios.biomeswevegone.world.level.block.custom.BWGFarmLandBlock;
import net.potionstudios.biomeswevegone.world.level.block.custom.BWGSpreadableBlock;
import net.potionstudios.biomeswevegone.world.level.block.custom.WitchHazelBlossomBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.PottedBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.BWGBerryBush;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.BWGPlacementBushBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.DesertPlantBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.FlowerableBushBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.FloweringBushBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.HydrangeaBushBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.HydrangeaHedgeBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.OddionCrop;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.ShrubBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.WhitePuffballBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.cactus.BarrelCactusBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.cactus.CarvedBarrelCactusBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.flower.BWGBonemealableFlowerBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.flower.BWGFlowerBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.flower.BWGTallFlowerBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.flower.BWGTallFlowerBlockTreeGrower;
import net.potionstudios.biomeswevegone.world.level.block.plants.flower.FlowerBlockFeature;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.branch.TreeBranchBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.fruit.BWGFruitBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.fruit.SoulFruitBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.grower.BWGTreeGrowers;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.AloeVeraBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.BWGDoublePlantBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.BWGMushroomBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.BloomingAloeVeraBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.BoneMealGrassBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.FlatVegetationBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.GlowCaneBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.PoisonIvyBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.cattail.CattailPlantBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.cattail.CattailSproutBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.cattail.FluorescentCattailPlantBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.pumpkin.EquipableCarvedPalePumpkinBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.pumpkin.PaleCarvedPumpkinBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.pumpkin.PalePumpkinBlock;
import net.potionstudios.biomeswevegone.world.level.block.sand.BWGQuickSand;
import net.potionstudios.biomeswevegone.world.level.block.sand.BWGSandSet;
import net.potionstudios.biomeswevegone.world.level.block.set.BWGBlockSet;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.configured.BWGOverworldVegetationConfiguredFeatures;

public class BWGBlocks {
    public static final ArrayList<Supplier<? extends Block>> cubeAllBlocks = new ArrayList();
    public static final ArrayList<Supplier<? extends Block>> BLOCKS = new ArrayList();
    public static final ArrayList<Supplier<? extends Item>> BLOCK_ITEMS = new ArrayList();
    public static final Supplier<Block> FORAGERS_TABLE = BWGBlocks.registerBlockItem("foragers_table", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLETCHING_TABLE)));
    public static final Supplier<Block> PEAT = BWGBlocks.registerBasicBlockWithItem("peat", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT));
    public static final Supplier<Block> SANDY_DIRT = BWGBlocks.registerBasicBlockWithItem("sandy_dirt", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT));
    public static final Supplier<DirtPathBlock> SANDY_DIRT_PATH = BWGBlocks.registerBlockItem("sandy_dirt_path", () -> new BWGDirtPathBlock(SANDY_DIRT));
    public static final Supplier<BWGFarmLandBlock> SANDY_FARMLAND = BWGBlocks.registerBlockItem("sandy_farmland", PlatformHandler.PLATFORM_HANDLER.bwgFarmLandBlock(SANDY_DIRT));
    public static final Supplier<Block> LUSH_DIRT = BWGBlocks.registerBasicBlockWithItem("lush_dirt", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT));
    public static final Supplier<BWGSpreadableBlock> LUSH_GRASS_BLOCK = BWGBlocks.registerBlockItem("lush_grass_block", () -> new BWGSpreadableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK), LUSH_DIRT));
    public static final Supplier<DirtPathBlock> LUSH_DIRT_PATH = BWGBlocks.registerBlockItem("lush_dirt_path", () -> new BWGDirtPathBlock(LUSH_DIRT));
    public static final Supplier<BWGFarmLandBlock> LUSH_FARMLAND = BWGBlocks.registerBlockItem("lush_farmland", PlatformHandler.PLATFORM_HANDLER.bwgFarmLandBlock(LUSH_DIRT));
    public static final BWGSandSet BLACK_SAND_SET = new BWGSandSet("black", 0x4F4F4F);
    public static final BWGSandSet WHITE_SAND_SET = new BWGSandSet("white", 0xEAEAEA);
    public static final BWGSandSet BLUE_SAND_SET = new BWGSandSet("blue", 13559021);
    public static final BWGSandSet PURPLE_SAND_SET = new BWGSandSet("purple", 12887002);
    public static final BWGSandSet PINK_SAND_SET = new BWGSandSet("pink", 0xEDCEEC);
    public static final BWGSandSet WINDSWEPT_SAND_SET = new BWGSandSet("windswept", 0xEDCEEC);
    public static final Supplier<RotatedPillarBlock> WINDSWEPT_SANDSTONE_PILLAR = BWGBlocks.registerBlockItem("windswept_sandstone_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE).mapColor(MapColor.COLOR_YELLOW)));
    public static final Supplier<ColoredFallingBlock> CRACKED_SAND = BWGBlocks.registerCubeAllBlockItem("cracked_sand", () -> new ColoredFallingBlock(new ColorRGBA(14406560), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND)));
    public static final Supplier<ColoredFallingBlock> CRACKED_RED_SAND = BWGBlocks.registerCubeAllBlockItem("cracked_red_sand", () -> new ColoredFallingBlock(new ColorRGBA(11098145), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_SAND)));
    public static final Supplier<BWGQuickSand> QUICKSAND = BWGBlocks.registerCubeAllBlockItem("quicksand", () -> new BWGQuickSand(0xFFFFFF));
    public static final Supplier<BWGQuickSand> RED_QUICKSAND = BWGBlocks.registerCubeAllBlockItem("red_quicksand", () -> new BWGQuickSand(11098145));
    public static final Supplier<IceBlock> BLACK_ICE = BWGBlocks.registerBlockItem("black_ice", () -> new IceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ICE)));
    public static final Supplier<IceBlock> PACKED_BLACK_ICE = BWGBlocks.registerCubeAllBlockItem("packed_black_ice", () -> new IceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE)));
    public static final Supplier<IceBlock> BOREALIS_ICE = BWGBlocks.registerBlockItem("borealis_ice", () -> new IceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ICE).lightLevel(state -> 10)));
    public static final Supplier<IceBlock> PACKED_BOREALIS_ICE = BWGBlocks.registerBlockItem("packed_borealis_ice", () -> new IceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE).lightLevel(state -> 10)));
    public static final Supplier<BWGBerryBush> BLUEBERRY_BUSH = BWGBlocks.registerBlock("blueberry_bush", () -> new BWGBerryBush(() -> BWGItems.BLUEBERRIES, true));
    public static final Supplier<FloweringBushBlock> FLOWERING_JACARANDA_BUSH = BWGBlocks.registerBlockItem("flowering_jacaranda_bush", () -> new FloweringBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AZALEA)));
    public static final PottedBlock JACARANDA_BUSH = BWGBlocks.createPottedVariant("jacaranda_bush", () -> new FlowerableBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AZALEA), FLOWERING_JACARANDA_BUSH));
    public static final Supplier<FloweringBushBlock> FLOWERING_INDIGO_JACARANDA_BUSH = BWGBlocks.registerBlockItem("flowering_indigo_jacaranda_bush", () -> new FloweringBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AZALEA)));
    public static final PottedBlock INDIGO_JACARANDA_BUSH = BWGBlocks.createPottedVariant("indigo_jacaranda_bush", () -> new FlowerableBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AZALEA), FLOWERING_INDIGO_JACARANDA_BUSH));
    public static final PottedBlock HYDRANGEA_BUSH = BWGBlocks.createPottedVariant("hydrangea_bush", HydrangeaBushBlock::new);
    public static final Supplier<BushBlock> HYDRANGEA_HEDGE = BWGBlocks.registerBlockItem("hydrangea_hedge", HydrangeaHedgeBlock::new);
    public static final PottedBlock SHRUB = BWGBlocks.createPottedVariant("shrub", () -> new ShrubBlock(null));
    public static final PottedBlock FIRECRACKER_FLOWER_BUSH = BWGBlocks.createPottedVariant("firecracker_flower_bush", () -> new ShrubBlock(BWGTreeGrowers.FIRECRACKER));
    public static final Supplier<OddionCrop> ODDION_CROP = BWGBlocks.registerBlock("oddion_crop", OddionCrop::new);
    public static final Supplier<HugeMushroomBlock> GREEN_MUSHROOM_BLOCK = BWGBlocks.registerBlockItem("green_mushroom_block", () -> new HugeMushroomBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.STEM).strength(0.2f)));
    public static final Supplier<HugeMushroomBlock> WEEPING_MILKCAP_MUSHROOM_BLOCK = BWGBlocks.registerBlockItem("weeping_milkcap_mushroom_block", () -> new HugeMushroomBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.STEM).strength(0.2f)));
    public static final Supplier<HugeMushroomBlock> WOOD_BLEWIT_MUSHROOM_BLOCK = BWGBlocks.registerBlockItem("wood_blewit_mushroom_block", () -> new HugeMushroomBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.STEM).strength(0.2f)));
    public static final Supplier<HugeMushroomBlock> WHITE_MUSHROOM_STEM = BWGBlocks.registerBlockItem("white_mushroom_stem", () -> new HugeMushroomBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.STEM).strength(0.2f)));
    public static final Supplier<HugeMushroomBlock> BROWN_MUSHROOM_STEM = BWGBlocks.registerBlockItem("brown_mushroom_stem", () -> new HugeMushroomBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.STEM).strength(0.2f)));
    public static final Supplier<MushroomBlock> GREEN_MUSHROOM = BWGBlocks.registerBlockItem("green_mushroom", () -> new BWGMushroomBlock(BlockBehaviour.Properties.of().noCollission().mapColor(MapColor.DIRT).sound(SoundType.STEM).strength(0.2f), BWGBlockTags.BWG_MUSHROOM_PLACEABLE, BWGOverworldVegetationConfiguredFeatures.HUGE_GREEN_MUSHROOM1, Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0)));
    public static final Supplier<MushroomBlock> WEEPING_MILKCAP = BWGBlocks.registerBlockItem("weeping_milkcap", () -> new BWGMushroomBlock(BlockBehaviour.Properties.of().noCollission().mapColor(MapColor.DIRT).sound(SoundType.STEM).strength(0.2f), BWGBlockTags.BWG_MUSHROOM_PLACEABLE, BWGOverworldVegetationConfiguredFeatures.HUGE_WEEPING_MILKCAP1, Block.box((double)3.0, (double)0.0, (double)3.0, (double)14.0, (double)6.0, (double)14.0)));
    public static final Supplier<MushroomBlock> WOOD_BLEWIT = BWGBlocks.registerBlockItem("wood_blewit", () -> new BWGMushroomBlock(BlockBehaviour.Properties.of().noCollission().mapColor(MapColor.DIRT).sound(SoundType.STEM).strength(0.2f), BWGBlockTags.BWG_MUSHROOM_PLACEABLE, BWGOverworldVegetationConfiguredFeatures.HUGE_WOOD_BLEWIT1, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0)));
    public static final Supplier<TallFlowerBlock> TALL_ALLIUM = BWGBlocks.registerTallFlower("tall_allium", BWGTreeGrowers.GIANT_ALLIUM);
    public static final FlowerBlockFeature ALLIUM_FLOWER_BUSH = BWGBlocks.registerFlower("allium_flower_bush", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), TALL_ALLIUM);
    public static final Supplier<Block> ALLIUM_PETAL_BLOCK = BWGBlocks.registerBasicBlockWithItem("allium_petal_block", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK).mapColor(MapColor.COLOR_MAGENTA).sound(SoundType.AZALEA));
    public static final FlowerBlockFeature PINK_ALLIUM = BWGBlocks.registerFlower("pink_allium", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0));
    public static final Supplier<TallFlowerBlock> TALL_PINK_ALLIUM = BWGBlocks.registerTallFlower("tall_pink_allium", BWGTreeGrowers.GIANT_PINK_ALLIUM);
    public static final FlowerBlockFeature PINK_ALLIUM_FLOWER_BUSH = BWGBlocks.registerFlower("pink_allium_flower_bush", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), TALL_PINK_ALLIUM);
    public static final Supplier<Block> PINK_ALLIUM_PETAL_BLOCK = BWGBlocks.registerBasicBlockWithItem("pink_allium_petal_block", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK).mapColor(MapColor.COLOR_PINK).sound(SoundType.AZALEA));
    public static final FlowerBlockFeature WHITE_ALLIUM = BWGBlocks.registerFlower("white_allium", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0));
    public static final Supplier<TallFlowerBlock> TALL_WHITE_ALLIUM = BWGBlocks.registerTallFlower("tall_white_allium", BWGTreeGrowers.GIANT_WHITE_ALLIUM);
    public static final FlowerBlockFeature WHITE_ALLIUM_FLOWER_BUSH = BWGBlocks.registerFlower("white_allium_flower_bush", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), TALL_WHITE_ALLIUM);
    public static final Supplier<Block> WHITE_ALLIUM_PETAL_BLOCK = BWGBlocks.registerBasicBlockWithItem("white_allium_petal_block", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK).mapColor(MapColor.TERRACOTTA_WHITE).sound(SoundType.AZALEA));
    public static final Supplier<TallFlowerBlock> CYAN_PITCHER_PLANT = BWGBlocks.registerTallGlowingFlower("cyan_pitcher_plant");
    public static final Supplier<TallFlowerBlock> MAGENTA_PITCHER_PLANT = BWGBlocks.registerTallGlowingFlower("magenta_pitcher_plant");
    public static final FlowerBlockFeature ROSE = BWGBlocks.registerFlower("rose", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    public static final FlowerBlockFeature OSIRIA_ROSE = BWGBlocks.registerFlower("osiria_rose", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    public static final FlowerBlockFeature BLACK_ROSE = BWGBlocks.registerFlower("black_rose", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    public static final FlowerBlockFeature CYAN_ROSE = BWGBlocks.registerFlower("cyan_rose", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    public static final Supplier<TallFlowerBlock> BLUE_ROSE_BUSH = BWGBlocks.registerTallFlower("blue_rose_bush");
    public static final Supplier<Block> ROSE_PETAL_BLOCK = BWGBlocks.registerBasicBlockWithItem("rose_petal_block", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK).mapColor(MapColor.TERRACOTTA_WHITE).sound(SoundType.AZALEA));
    public static final FlowerBlockFeature CYAN_TULIP = BWGBlocks.registerFlower("cyan_tulip", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
    public static final FlowerBlockFeature GREEN_TULIP = BWGBlocks.registerFlower("green_tulip", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
    public static final FlowerBlockFeature MAGENTA_TULIP = BWGBlocks.registerFlower("magenta_tulip", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
    public static final FlowerBlockFeature PURPLE_TULIP = BWGBlocks.registerFlower("purple_tulip", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
    public static final FlowerBlockFeature YELLOW_TULIP = BWGBlocks.registerFlower("yellow_tulip", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
    public static final FlowerBlockFeature AMARANTH = BWGBlocks.registerFlower("amaranth", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0));
    public static final FlowerBlockFeature CYAN_AMARANTH = BWGBlocks.registerFlower("cyan_amaranth", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0));
    public static final FlowerBlockFeature MAGENTA_AMARANTH = BWGBlocks.registerFlower("magenta_amaranth", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0));
    public static final FlowerBlockFeature ORANGE_AMARANTH = BWGBlocks.registerFlower("orange_amaranth", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0));
    public static final FlowerBlockFeature PURPLE_AMARANTH = BWGBlocks.registerFlower("purple_amaranth", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0));
    public static final FlowerBlockFeature BLUE_SAGE = BWGBlocks.registerFlower("blue_sage", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0));
    public static final FlowerBlockFeature PURPLE_SAGE = BWGBlocks.registerFlower("purple_sage", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0));
    public static final FlowerBlockFeature WHITE_SAGE = BWGBlocks.registerFlower("white_sage", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0));
    public static final FlowerBlockFeature DAFFODIL = BWGBlocks.registerFlower("daffodil", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    public static final FlowerBlockFeature PINK_DAFFODIL = BWGBlocks.registerFlower("pink_daffodil", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    public static final FlowerBlockFeature YELLOW_DAFFODIL = BWGBlocks.registerFlower("yellow_daffodil", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    public static final FlowerBlockFeature PINK_ANEMONE = BWGBlocks.registerFlower("pink_anemone", Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0));
    public static final FlowerBlockFeature WHITE_ANEMONE = BWGBlocks.registerFlower("white_anemone", Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0));
    public static final FlowerBlockFeature ALPINE_BELLFLOWER = BWGBlocks.registerFlower("alpine_bellflower", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0));
    public static final FlowerBlockFeature LAZARUS_BELLFLOWER = BWGBlocks.registerFlower("lazarus_bellflower", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
    public static final FlowerBlockFeature PEACH_LEATHER_FLOWER = BWGBlocks.registerFlower("peach_leather_flower", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
    public static final FlowerBlockFeature VIOLET_LEATHER_FLOWER = BWGBlocks.registerFlower("violet_leather_flower", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
    public static final FlowerBlockFeature ANGELICA = BWGBlocks.registerFlower("angelica", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0));
    public static final FlowerBlockFeature BEGONIA = BWGBlocks.registerFlower("begonia", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0));
    public static final FlowerBlockFeature BISTORT = BWGBlocks.registerFlower("bistort", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
    public static final FlowerBlockFeature CALIFORNIA_POPPY = BWGBlocks.registerFlower("california_poppy");
    public static final FlowerBlockFeature CROCUS = BWGBlocks.registerFlower("crocus", Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0));
    public static final Supplier<TallFlowerBlock> DELPHINIUM = BWGBlocks.registerTallFlower("delphinium");
    public static final FlowerBlockFeature FAIRY_SLIPPER = BWGBlocks.registerFlower("fairy_slipper", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_TULIP).noOcclusion().lightLevel(level -> 8), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0));
    public static final Supplier<TallFlowerBlock> FOXGLOVE = BWGBlocks.registerTallFlower("foxglove");
    public static final FlowerBlockFeature GUZMANIA = BWGBlocks.registerFlower("guzmania", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0));
    public static final FlowerBlockFeature INCAN_LILY = BWGBlocks.registerFlower("incan_lily", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0));
    public static final FlowerBlockFeature IRIS = BWGBlocks.registerFlower("iris", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
    public static final Supplier<TallFlowerBlock> JAPANESE_ORCHID = BWGBlocks.registerTallFlower("japanese_orchid");
    public static final FlowerBlockFeature KOVAN_FLOWER = BWGBlocks.registerFlower("kovan_flower", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0));
    public static final FlowerBlockFeature LOLLIPOP_FLOWER = BWGBlocks.registerFlower("lollipop_flower", Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0));
    public static final FlowerBlockFeature ORANGE_DAISY = BWGBlocks.registerFlower("orange_daisy", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0));
    public static final FlowerBlockFeature PROTEA_FLOWER = BWGBlocks.registerFlower("protea_flower", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
    public static final FlowerBlockFeature RICHEA = BWGBlocks.registerFlower("richea", Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
    public static final FlowerBlockFeature SILVER_VASE_FLOWER = BWGBlocks.registerFlower("silver_vase_flower");
    public static final FlowerBlockFeature HORSEWEED = BWGBlocks.registerFlower("horseweed", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0));
    public static final FlowerBlockFeature WINTER_SUCCULENT = BWGBlocks.registerFlower("winter_succulent", Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0));
    public static final PottedBlock SNOWDROPS = BWGBlocks.createPottedVariant("snowdrops", () -> new BWGPlacementBushBlock(BlockBehaviour.Properties.of().sound(SoundType.GRASS).strength(0.0f).noCollission().noOcclusion(), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), BWGBlockTags.SNOWY_PLANT_PLACEABLE));
    public static final PottedBlock WINTER_CYCLAMEN = BWGBlocks.createPottedVariant("winter_cyclamen", () -> new BWGPlacementBushBlock(BlockBehaviour.Properties.of().sound(SoundType.GRASS).strength(0.0f).noCollission().noOcclusion(), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), BWGBlockTags.SNOWY_PLANT_PLACEABLE));
    public static final PottedBlock WINTER_ROSE = BWGBlocks.createPottedVariant("winter_rose", () -> new BWGPlacementBushBlock(BlockBehaviour.Properties.of().sound(SoundType.GRASS).strength(0.0f).noCollission().noOcclusion(), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), BWGBlockTags.SNOWY_PLANT_PLACEABLE));
    public static final PottedBlock WINTER_SCILLA = BWGBlocks.createPottedVariant("winter_scilla", () -> new BWGPlacementBushBlock(BlockBehaviour.Properties.of().sound(SoundType.GRASS).strength(0.0f).noCollission().noOcclusion(), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), BWGBlockTags.SNOWY_PLANT_PLACEABLE));
    public static final Supplier<CattailPlantBlock> CATTAIL = BWGBlocks.registerBlock("cattail", () -> new CattailPlantBlock(() -> BWGItems.CATTAIL_SPROUT));
    public static final Supplier<CattailSproutBlock> CATTAIL_SPROUT = BWGBlocks.registerBlock("cattail_sprout", () -> new CattailSproutBlock(CATTAIL));
    public static final Supplier<FluorescentCattailPlantBlock> FLUORESCENT_CATTAIL = BWGBlocks.registerBlock("fluorescent_cattail", () -> new FluorescentCattailPlantBlock(() -> BWGItems.FLUORESCENT_CATTAIL_SPROUT));
    public static final Supplier<CattailSproutBlock> FLUORESCENT_CATTAIL_SPROUT = BWGBlocks.registerBlock("fluorescent_cattail_sprout", () -> new CattailSproutBlock(FLUORESCENT_CATTAIL));
    public static final Supplier<GlowCaneBlock> BLUE_GLOWCANE = BWGBlocks.registerBlock("blue_glowcane", () -> new GlowCaneBlock(() -> BWGItems.BLUE_GLOWCANE_SHOOT));
    public static final Supplier<GlowCaneBlock> GREEN_GLOWCANE = BWGBlocks.registerBlock("green_glowcane", () -> new GlowCaneBlock(() -> BWGItems.GREEN_GLOWCANE_SHOOT));
    public static final Supplier<GlowCaneBlock> RED_GLOWCANE = BWGBlocks.registerBlock("red_glowcane", () -> new GlowCaneBlock(() -> BWGItems.RED_GLOWCANE_SHOOT));
    public static final Supplier<GlowCaneBlock> YELLOW_GLOWCANE = BWGBlocks.registerBlock("yellow_glowcane", () -> new GlowCaneBlock(() -> BWGItems.YELLOW_GLOWCANE_SHOOT));
    public static final Supplier<LanternBlock> BLUE_GLOW_BOTTLE = BWGBlocks.registerBlockItem("blue_glow_bottle", () -> new LanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(light -> 14)));
    public static final Supplier<LanternBlock> GREEN_GLOW_BOTTLE = BWGBlocks.registerBlockItem("green_glow_bottle", () -> new LanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(light -> 14)));
    public static final Supplier<LanternBlock> RED_GLOW_BOTTLE = BWGBlocks.registerBlockItem("red_glow_bottle", () -> new LanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(light -> 14)));
    public static final Supplier<LanternBlock> YELLOW_GLOW_BOTTLE = BWGBlocks.registerBlockItem("yellow_glow_bottle", () -> new LanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).lightLevel(light -> 14)));
    public static final PottedBlock WHITE_PUFFBALL = BWGBlocks.createPottedVariantWithoutItem("white_puffball", WhitePuffballBlock::new);
    public static final Supplier<DoublePlantBlock> TALL_PRAIRIE_GRASS = BWGBlocks.registerBlockItem("tall_prairie_grass", () -> new BWGDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).mapColor(MapColor.COLOR_GREEN), (TagKey<Block>)BlockTags.DIRT));
    public static final Supplier<BoneMealGrassBlock> PRAIRIE_GRASS = BWGBlocks.registerBlockItem("prairie_grass", () -> new BoneMealGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS), TALL_PRAIRIE_GRASS, (TagKey<Block>)BlockTags.DIRT));
    public static final Supplier<DoublePlantBlock> TALL_BEACH_GRASS = BWGBlocks.registerBlockItem("tall_beach_grass", () -> new BWGDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).mapColor(MapColor.COLOR_GREEN), (TagKey<Block>)BlockTags.SAND));
    public static final Supplier<BoneMealGrassBlock> BEACH_GRASS = BWGBlocks.registerBlockItem("beach_grass", () -> new BoneMealGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS), TALL_BEACH_GRASS, (TagKey<Block>)BlockTags.SAND));
    public static final Supplier<FlatVegetationBlock> LEAF_PILE = BWGBlocks.registerBlockItem("leaf_pile", FlatVegetationBlock::new);
    public static final Supplier<FlatVegetationBlock> CLOVER_PATCH = BWGBlocks.registerBlockItem("clover_patch", FlatVegetationBlock::new);
    public static final Supplier<FlatVegetationBlock> FLOWER_PATCH = BWGBlocks.registerBlockItem("flower_patch", FlatVegetationBlock::new);
    public static final Supplier<PinkPetalsBlock> WHITE_SAKURA_PETALS = BWGBlocks.registerBlockItem("white_sakura_petals", () -> new PinkPetalsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS).mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final Supplier<PinkPetalsBlock> YELLOW_SAKURA_PETALS = BWGBlocks.registerBlockItem("yellow_sakura_petals", () -> new PinkPetalsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS).mapColor(MapColor.COLOR_YELLOW)));
    public static final Supplier<PoisonIvyBlock> POISON_IVY = BWGBlocks.registerBlockItem("poison_ivy", PoisonIvyBlock::new);
    public static final Supplier<VineBlock> SKYRIS_VINE = BWGBlocks.registerBlockItem("skyris_vine", () -> new VineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE)));
    public static final Supplier<TreeBranchBlock> WITCH_HAZEL_BRANCH = BWGBlocks.registerBlockItem("witch_hazel_branch", TreeBranchBlock::new);
    public static final Supplier<WitchHazelBlossomBlock> WITCH_HAZEL_BLOSSOM = BWGBlocks.registerBlockItem("witch_hazel_blossom", WitchHazelBlossomBlock::new);
    public static final Supplier<TreeBranchBlock> SHELF_FUNGI = BWGBlocks.registerBlockItem("shelf_fungi", TreeBranchBlock::new);
    public static final PottedBlock MINI_CACTUS = BWGBlocks.createPottedVariant("mini_cactus", () -> new DesertPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CACTUS).noOcclusion().noCollission(), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (TagKey<Block>)BlockTags.SAND));
    public static final PottedBlock PRICKLY_PEAR_CACTUS = BWGBlocks.createPottedVariant("prickly_pear_cactus", () -> new DesertPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CACTUS).noOcclusion().noCollission(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (TagKey<Block>)BlockTags.SAND));
    public static final PottedBlock GOLDEN_SPINED_CACTUS = BWGBlocks.createPottedVariant("golden_spined_cactus", () -> new DesertPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CACTUS).noOcclusion().noCollission(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (TagKey<Block>)BlockTags.SAND));
    public static final Supplier<BarrelCactusBlock> BARREL_CACTUS = BWGBlocks.registerBlockItem("barrel_cactus", BarrelCactusBlock::new);
    public static final Supplier<BarrelCactusBlock> FLOWERING_BARREL_CACTUS = BWGBlocks.registerBlockItem("flowering_barrel_cactus", BarrelCactusBlock::new);
    public static final Supplier<CarvedBarrelCactusBlock> CARVED_BARREL_CACTUS = BWGBlocks.registerBlockItem("carved_barrel_cactus", CarvedBarrelCactusBlock::new);
    public static final Supplier<AloeVeraBlock> ALOE_VERA = BWGBlocks.registerBlockItem("aloe_vera", AloeVeraBlock::new);
    public static final Supplier<BloomingAloeVeraBlock> BLOOMING_ALOE_VERA = BWGBlocks.registerBlock("blooming_aloe_vera", BloomingAloeVeraBlock::new);
    public static final Supplier<WaterlilyBlock> TINY_LILY_PADS = BWGBlocks.registerBlock("tiny_lily_pads", () -> new WaterlilyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD)));
    public static final Supplier<WaterlilyBlock> FLOWERING_TINY_LILY_PADS = BWGBlocks.registerBlock("flowering_tiny_lily_pads", () -> new WaterlilyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD)));
    public static final Supplier<BWGFruitBlock> APPLE_FRUIT_BLOCK = BWGBlocks.registerBlock("apple_fruit", () -> new BWGFruitBlock(() -> () -> Items.APPLE, "ripe_orchard_leaves"));
    public static final Supplier<BWGFruitBlock> BAOBAB_FRUIT_BLOCK = BWGBlocks.registerBlock("baobab_fruit", () -> new BWGFruitBlock(() -> BWGItems.BAOBAB_FRUIT, "ripe_baobab_leaves"));
    public static final Supplier<BWGFruitBlock> GREEN_APPLE_FRUIT_BLOCK = BWGBlocks.registerBlock("green_apple_fruit", () -> new BWGFruitBlock(() -> BWGItems.GREEN_APPLE, "green_apple_skyris_leaves"));
    public static final Supplier<BWGFruitBlock> YUCCA_FRUIT_BLOCK = BWGBlocks.registerBlock("yucca_fruit", () -> new BWGFruitBlock(() -> BWGItems.YUCCA_FRUIT, "ripe_yucca_leaves"));
    public static final Supplier<SoulFruitBlock> SOUL_FRUIT_BLOCK = BWGBlocks.registerBlock("soul_fruit", SoulFruitBlock::new);
    public static final BWGBlockSet DACITE_SET = new BWGBlockSet("dacite", MapColor.TERRACOTTA_WHITE);
    public static final BWGBlockSet DACITE_BRICKS_SET = new BWGBlockSet("dacite_bricks", "dacite_brick", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).mapColor(MapColor.TERRACOTTA_WHITE));
    public static final BWGBlockSet DACITE_COBBLESTONE_SET = new BWGBlockSet("dacite_cobblestone", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).mapColor(MapColor.TERRACOTTA_WHITE));
    public static final Supplier<RotatedPillarBlock> DACITE_PILLAR = BWGBlocks.registerBlockItem("dacite_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final BWGBlockSet DACITE_TILE_SET = new BWGBlockSet("dacite_tile", MapColor.TERRACOTTA_WHITE);
    public static final Supplier<SnowyDirtBlock> PODZOL_DACITE = BWGBlocks.registerBlockItem("podzol_dacite", () -> new SnowyDirtBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final Supplier<BWGSpreadableBlock> OVERGROWN_DACITE = BWGBlocks.registerBlockItem("overgrown_dacite", () -> new BWGSpreadableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).randomTicks(), DACITE_SET::getBase));
    public static final Supplier<BWGSpreadableBlock> OVERGROWN_STONE = BWGBlocks.registerBlockItem("overgrown_stone", () -> new BWGSpreadableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).randomTicks(), () -> Blocks.STONE));
    public static final BWGBlockSet RED_ROCK_SET = new BWGBlockSet("red_rock", MapColor.COLOR_RED);
    public static final BWGBlockSet RED_ROCK_BRICKS_SET = new BWGBlockSet("red_rock_bricks", "red_rock_brick", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).mapColor(MapColor.COLOR_RED));
    public static final BWGBlockSet CRACKED_RED_ROCK_BRICKS_SET = new BWGBlockSet("cracked_red_rock_bricks", "cracked_red_rock_brick", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRACKED_STONE_BRICKS).mapColor(MapColor.COLOR_RED));
    public static final BWGBlockSet CHISELED_RED_ROCK_BRICKS_SET = new BWGBlockSet("chiseled_red_rock_bricks", "chiseled_red_rock_brick", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHISELED_STONE_BRICKS).mapColor(MapColor.COLOR_RED));
    public static final BWGBlockSet MOSSY_RED_ROCK_BRICKS_SET = new BWGBlockSet("mossy_red_rock_bricks", "mossy_red_rock_brick", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSSY_STONE_BRICKS).mapColor(MapColor.COLOR_RED));
    public static final BWGBlockSet MOSSY_STONE_SET = new BWGBlockSet("mossy_stone", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSSY_COBBLESTONE));
    public static final BWGBlockSet ROCKY_STONE_SET = new BWGBlockSet("rocky_stone", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE));
    public static final Supplier<MudBlock> PALE_MUD = BWGBlocks.registerCubeAllBlockItem("pale_mud", () -> new MudBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final Supplier<Block> PACKED_PALE_MUD = BWGBlocks.registerBasicBlockWithItem("packed_pale_mud", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_MUD));
    public static final BWGBlockSet PALE_MUD_BRICKS_SET = new BWGBlockSet("pale_mud_bricks", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD_BRICKS));
    public static final Supplier<Block> WATER_SILK = BWGBlocks.registerBlock("water_silk", () -> new WaterlilyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).noCollission().mapColor(MapColor.COLOR_GREEN)));
    public static final Supplier<HayBlock> CATTAIL_THATCH = BWGBlocks.registerBlockItem("cattail_thatch", () -> new HayBlock(BlockBehaviour.Properties.of().sound(SoundType.GRASS).strength(0.5f)));
    public static final Supplier<SlabBlock> CATTAIL_THATCH_SLAB = BWGBlocks.registerBlockItem("cattail_thatch_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CATTAIL_THATCH.get()))));
    public static final Supplier<StairBlock> CATTAIL_THATCH_STAIRS = BWGBlocks.registerBlockItem("cattail_thatch_stairs", () -> new StairBlock(CATTAIL_THATCH.get().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CATTAIL_THATCH.get()))));
    public static final Supplier<WoolCarpetBlock> CATTAIL_THATCH_CARPET = BWGBlocks.registerBlockItem("cattail_thatch_carpet", () -> new WoolCarpetBlock(DyeColor.BROWN, BlockBehaviour.Properties.of().sound(SoundType.GRASS).strength(0.5f)));
    public static final Supplier<AttachedStemBlock> ATTACHED_PALE_PUMPKIN_STEM = BWGBlocks.registerBlock("attached_pale_pumpkin_stem", () -> new AttachedStemBlock(BiomesWeveGone.key(Registries.BLOCK, "pale_pumpkin_stem"), BiomesWeveGone.key(Registries.BLOCK, "pale_pumpkin"), BiomesWeveGone.key(Registries.ITEM, "pale_pumpkin_seeds"), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ATTACHED_PUMPKIN_STEM)));
    public static final Supplier<StemBlock> PALE_PUMPKIN_STEM = BWGBlocks.registerBlock("pale_pumpkin_stem", () -> new StemBlock(BiomesWeveGone.key(Registries.BLOCK, "pale_pumpkin"), BiomesWeveGone.key(Registries.BLOCK, "attached_pale_pumpkin_stem"), BiomesWeveGone.key(Registries.ITEM, "pale_pumpkin_seeds"), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PUMPKIN_STEM)));
    public static final Supplier<PalePumpkinBlock> PALE_PUMPKIN = BWGBlocks.registerBlockItem("pale_pumpkin", PalePumpkinBlock::new);
    public static final Supplier<EquipableCarvedPalePumpkinBlock> CARVED_PALE_PUMPKIN = BWGBlocks.registerBlockItem("carved_pale_pumpkin", EquipableCarvedPalePumpkinBlock::new);
    public static final Supplier<PaleCarvedPumpkinBlock> PALE_JACK_O_LANTERN = BWGBlocks.registerBlockItem("pale_jack_o_lantern", PaleCarvedPumpkinBlock::new);

    private static FlowerBlockFeature registerFlower(String key) {
        Supplier<BWGFlowerBlock> flower = BWGBlocks.registerBlockItem(key, () -> new BWGFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_TULIP).noOcclusion()));
        return new FlowerBlockFeature(key, flower);
    }

    private static FlowerBlockFeature registerFlower(String key, VoxelShape shape) {
        Supplier<BWGFlowerBlock> flower = BWGBlocks.registerBlockItem(key, () -> new BWGFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_TULIP).noOcclusion(), (TagKey<Block>)BlockTags.DIRT, shape));
        return new FlowerBlockFeature(key, flower);
    }

    private static FlowerBlockFeature registerFlower(String key, VoxelShape shape, Supplier<? extends Block> growAble) {
        Supplier<BWGBonemealableFlowerBlock> flower = BWGBlocks.registerBlockItem(key, () -> new BWGBonemealableFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_TULIP).noOcclusion(), (TagKey<Block>)BlockTags.DIRT, shape, growAble));
        return new FlowerBlockFeature(key, flower);
    }

    private static FlowerBlockFeature registerFlower(String key, BlockBehaviour.Properties properties, VoxelShape shape) {
        Supplier<BWGFlowerBlock> flower = BWGBlocks.registerBlockItem(key, () -> new BWGFlowerBlock(properties, (TagKey<Block>)BlockTags.DIRT, shape));
        return new FlowerBlockFeature(key, flower);
    }

    private static Supplier<TallFlowerBlock> registerTallFlower(String key) {
        return BWGBlocks.registerBlockItem(key, () -> new BWGTallFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SUNFLOWER).noOcclusion()));
    }

    private static Supplier<TallFlowerBlock> registerTallFlower(String key, Supplier<TreeGrower> treeGrower) {
        return BWGBlocks.registerBlockItem(key, () -> new BWGTallFlowerBlockTreeGrower(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SUNFLOWER).noOcclusion(), treeGrower));
    }

    private static Supplier<TallFlowerBlock> registerTallGlowingFlower(String key) {
        return BWGBlocks.registerBlockItem(key, () -> new BWGTallFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SUNFLOWER).lightLevel(state -> 10).noOcclusion()));
    }

    public static Supplier<Block> registerBasicBlockWithItem(String key, BlockBehaviour.Properties properties) {
        return BWGBlocks.registerCubeAllBlockItem(key, () -> new Block(properties));
    }

    public static <B extends Block> Supplier<B> registerBlockItem(String key, Supplier<B> blockSupplier) {
        Supplier block = BWGBlocks.registerBlock(key, blockSupplier);
        Supplier<Item> item = BWGItems.register(key, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        BLOCK_ITEMS.add(item);
        return block;
    }

    public static <B extends Block> Supplier<B> registerBlockItemNoTab(String key, Supplier<B> blockSupplier) {
        Supplier block = BWGBlocks.registerBlock(key, blockSupplier);
        BWGItems.register(key, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static <B extends Block> Supplier<B> registerCubeAllBlockItem(String key, Supplier<B> blockSupplier) {
        Supplier<B> block = BWGBlocks.registerBlockItem(key, blockSupplier);
        cubeAllBlocks.add(block);
        return block;
    }

    public static <B extends Block> PottedBlock createPottedVariant(String key, Supplier<B> blockSupplier) {
        Supplier<B> block = BWGBlocks.registerBlockItem(key, blockSupplier);
        return new PottedBlock(key, block);
    }

    public static <B extends Block> PottedBlock createPottedVariantWithoutItem(String key, Supplier<B> blockSupplier) {
        Supplier<B> block = BWGBlocks.registerBlock(key, blockSupplier);
        return new PottedBlock(key, block);
    }

    public static <B extends Block> Supplier<B> registerBlock(String id, Supplier<B> block) {
        Supplier<B> blockSupplier = BWGBlocks.register(id, block);
        BLOCKS.add(blockSupplier);
        return blockSupplier;
    }

    public static <B extends Block> Supplier<B> register(String id, Supplier<B> block) {
        return PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.BLOCK, id, block);
    }

    public static void blocks() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone Blocks");
        BWGWood.wood();
    }
}

