/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.atlasapi.internal;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.EmptyModel;

public class PassthroughBakedModel
implements BakedModel {
    BakedModel model = EmptyModel.BAKED;
    ItemOverrides overrides;

    public PassthroughBakedModel(final BakedModelSupplier modelSupplier, ModelBaker baker) {
        BlockModel blockmodel = (BlockModel)baker.getModel(ModelBakery.MISSING_MODEL_LOCATION);
        this.overrides = new ItemOverrides(this, baker, (UnbakedModel)blockmodel, List.of(), baker.getModelTextureGetter()){

            @Nullable
            public BakedModel resolve(BakedModel pModel, ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
                return modelSupplier.get(pModel, pStack, pLevel, pEntity, pSeed);
            }
        };
    }

    public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pDirection, RandomSource pRandom) {
        return this.model.getQuads(pState, pDirection, pRandom);
    }

    public boolean useAmbientOcclusion() {
        return this.model.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.model.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.model.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.model.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.model.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    public ItemTransforms getTransforms() {
        return this.model.getTransforms();
    }

    public static interface BakedModelSupplier {
        public BakedModel get(BakedModel var1, ItemStack var2, @Nullable ClientLevel var3, @Nullable LivingEntity var4, int var5);
    }
}

