/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.loot;

import com.buuz135.sushigocrafting.loot.ItemWeightedItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class SeedsLootModifier
extends LootModifier {
    public static final MapCodec<SeedsLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> SeedsLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SeedsLootModifier::new));
    private final List<ItemWeightedItem> seeds = new ArrayList<ItemWeightedItem>();

    public SeedsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.seeds.add(new ItemWeightedItem(Items.WHEAT_SEEDS, 100));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.RICE_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.SESAME_SEEDS.get(), 10));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.WASABI_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.SOY_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.CUCUMBER_SEEDS.get(), 25));
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList customLoot = new ObjectArrayList();
        for (ItemStack stack : generatedLoot) {
            if (stack.getItem() == Items.WHEAT_SEEDS) {
                WeightedRandom.getRandomItem((RandomSource)context.getRandom(), this.seeds).ifPresent(itemWeightedItem -> {
                    ItemStack weightedStack = new ItemStack((ItemLike)itemWeightedItem.getStack());
                    weightedStack.setCount(stack.getCount());
                    customLoot.add((Object)weightedStack);
                });
                continue;
            }
            customLoot.add((Object)stack);
        }
        return customLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

