/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.api.impl;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.item.FoodItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FoodHelper {
    public static HashMap<String, List<DeferredHolder<Item, Item>>> REGISTERED = new LinkedHashMap<String, List<DeferredHolder<Item, Item>>>();

    public static List<FoodData> generateFood(IFoodType type) {
        ArrayList<FoodData> items = new ArrayList<FoodData>();
        items.addAll(FoodHelper.generate(type, type.getFoodIngredients()));
        return items;
    }

    private static List<FoodData> generate(IFoodType type, List<IFoodIngredient[]> foodIngredients) {
        ArrayList<FoodData> items = new ArrayList<FoodData>();
        if (foodIngredients.size() == 1) {
            for (IFoodIngredient iFoodIngredient : foodIngredients.get(0)) {
                FoodData item = new FoodData(type);
                item.getFoodIngredients().add(iFoodIngredient);
                items.add(item);
            }
        } else {
            for (IFoodIngredient iFoodIngredient : foodIngredients.get(0)) {
                List<FoodData> all = FoodHelper.generate(type, foodIngredients.subList(1, foodIngredients.size()));
                for (FoodData item : all) {
                    if (item == null) continue;
                    item.getFoodIngredients().add(0, iFoodIngredient);
                }
                items.addAll(all);
            }
        }
        return items;
    }

    public static String getName(FoodData item) {
        ArrayList<String> names = new ArrayList<String>();
        for (int nameIndex : item.getFoodType().getNameIndex()) {
            if (item.getFoodIngredients().get(nameIndex).isEmpty()) continue;
            names.add(item.getFoodIngredients().get(nameIndex).getName());
        }
        names.add(item.getFoodType().getName());
        return String.join((CharSequence)"_", names);
    }

    public static FoodItem getFoodFromIngredients(String type, List<IFoodIngredient> foodIngredients) {
        for (DeferredHolder<Item, Item> foodItem : REGISTERED.get(type)) {
            if (foodIngredients.size() != ((FoodItem)((Object)foodItem.get())).getIngredientList().size()) continue;
            boolean allMatch = true;
            for (int i = 0; i < foodIngredients.size(); ++i) {
                if (foodIngredients.get(i).equals(((FoodItem)((Object)foodItem.get())).getIngredientList().get(i))) continue;
                allMatch = false;
            }
            if (!allMatch) continue;
            return (FoodItem)((Object)foodItem.get());
        }
        return null;
    }

    public static class FoodData {
        private final IFoodType foodType;
        private final List<IFoodIngredient> foodIngredients;

        public FoodData(IFoodType foodType) {
            this.foodType = foodType;
            this.foodIngredients = new ArrayList<IFoodIngredient>();
        }

        public List<IFoodIngredient> getFoodIngredients() {
            return this.foodIngredients;
        }

        public IFoodType getFoodType() {
            return this.foodType;
        }
    }
}

