/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.router.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import mcjty.xnet.modules.router.LocalChannelId;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record RouterData(int channelCount, Map<LocalChannelId, String> publishedChannels) {
    public static final RouterData EMPTY = new RouterData(0, new HashMap<LocalChannelId, String>());
    private static final Codec<ChannelData> CHANNEL_DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LocalChannelId.CODEC.fieldOf("channel").forGetter(ChannelData::channel), (App)Codec.STRING.fieldOf("name").forGetter(ChannelData::name)).apply((Applicative)instance, ChannelData::new));
    public static final Codec<RouterData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("channelCount").forGetter(RouterData::channelCount), (App)CHANNEL_DATA_CODEC.listOf().fieldOf("publishedChannels").forGetter(s -> s.publishedChannels().entrySet().stream().map(p -> new ChannelData((LocalChannelId)p.getKey(), (String)p.getValue())).toList())).apply((Applicative)instance, (channelCount, publishedChannels) -> {
        HashMap<LocalChannelId, String> map = new HashMap<LocalChannelId, String>();
        publishedChannels.forEach(pair -> map.put(pair.channel(), pair.name()));
        return new RouterData((int)channelCount, (Map<LocalChannelId, String>)map);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, RouterData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, RouterData::channelCount, (StreamCodec)ByteBufCodecs.map(HashMap::new, LocalChannelId.STREAM_CODEC, (StreamCodec)ByteBufCodecs.STRING_UTF8), RouterData::publishedChannels, RouterData::new);

    public RouterData withChannelCount(int channelCount) {
        return new RouterData(channelCount, this.publishedChannels);
    }

    public RouterData removeChannel(LocalChannelId channel) {
        HashMap<LocalChannelId, String> newChannels = new HashMap<LocalChannelId, String>(this.publishedChannels);
        newChannels.remove(channel);
        return new RouterData(this.channelCount, newChannels);
    }

    public RouterData addChannel(LocalChannelId channel, String name) {
        HashMap<LocalChannelId, String> newChannels = new HashMap<LocalChannelId, String>(this.publishedChannels);
        newChannels.put(channel, name);
        return new RouterData(this.channelCount, newChannels);
    }

    public record ChannelData(LocalChannelId channel, String name) {
    }
}

