/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.XNet;
import mcjty.xnet.client.ConnectorClientInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ChannelClientInfo {
    @Nonnull
    private final IChannelType type;
    @Nonnull
    private final IChannelSettings channelSettings;
    @Nonnull
    private final String channelName;
    private final boolean enabled;
    private final Map<SidedConsumer, ConnectorClientInfo> connectors = new HashMap<SidedConsumer, ConnectorClientInfo>();
    public static final StreamCodec<RegistryFriendlyByteBuf, ChannelClientInfo> STREAM_CODEC = StreamCodec.of((buf, info) -> {
        buf.writeUtf(info.type.getID());
        StreamCodec streamCodec = info.type.getStreamCodec();
        streamCodec.encode(buf, (Object)info.channelSettings);
        buf.writeUtf(info.getChannelName());
        buf.writeBoolean(info.isEnabled());
        buf.writeInt(info.connectors.size());
        for (Map.Entry<SidedConsumer, ConnectorClientInfo> pair : info.connectors.entrySet()) {
            SidedConsumer.STREAM_CODEC.encode(buf, (Object)pair.getKey());
            ConnectorClientInfo.STREAM_CODEC.encode(buf, (Object)pair.getValue());
        }
    }, buf -> {
        String id = buf.readUtf(Short.MAX_VALUE);
        IChannelType type = XNet.xNetApi.findType(id);
        IChannelSettings settings = (IChannelSettings)type.getStreamCodec().decode(buf);
        String name = buf.readUtf(Short.MAX_VALUE);
        boolean enabled = buf.readBoolean();
        HashMap<SidedConsumer, ConnectorClientInfo> connectors = new HashMap<SidedConsumer, ConnectorClientInfo>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            SidedConsumer key = (SidedConsumer)SidedConsumer.STREAM_CODEC.decode(buf);
            connectors.put(key, (ConnectorClientInfo)ConnectorClientInfo.STREAM_CODEC.decode(buf));
        }
        ChannelClientInfo info = new ChannelClientInfo(name, type, settings, enabled);
        info.connectors.clear();
        info.connectors.putAll(connectors);
        return info;
    });

    public ChannelClientInfo(@Nonnull String channelName, @Nonnull IChannelType type, @Nonnull IChannelSettings channelSettings, boolean enabled) {
        this.channelName = channelName;
        this.type = type;
        this.channelSettings = channelSettings;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName;
    }

    @Nonnull
    public IChannelType getType() {
        return this.type;
    }

    @Nonnull
    public IChannelSettings getChannelSettings() {
        return this.channelSettings;
    }

    @Nonnull
    public Map<SidedConsumer, ConnectorClientInfo> getConnectors() {
        return this.connectors;
    }

    public static class Serializer
    implements ISerializer<ChannelClientInfo> {
        public Function<RegistryFriendlyByteBuf, ChannelClientInfo> getDeserializer() {
            return buf -> {
                if (buf.readBoolean()) {
                    return (ChannelClientInfo)STREAM_CODEC.decode(buf);
                }
                return null;
            };
        }

        public BiConsumer<RegistryFriendlyByteBuf, ChannelClientInfo> getSerializer() {
            return (buf, info) -> {
                if (info == null) {
                    buf.writeBoolean(false);
                } else {
                    buf.writeBoolean(true);
                    STREAM_CODEC.encode(buf, info);
                }
            };
        }
    }
}

