/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.fluids;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.xnet.apiimpl.fluids.FluidChannelSettings;
import mcjty.xnet.apiimpl.fluids.FluidConnectorSettings;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;

public class FluidChannelType
implements IChannelType {
    public String getID() {
        return "xnet.fluid";
    }

    public String getName() {
        return I18nConstants.CHANNEL_FLUID.i18n(new Object[0]);
    }

    public MapCodec<? extends IChannelSettings> getCodec() {
        return FluidChannelSettings.CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ? extends IChannelSettings> getStreamCodec() {
        return FluidChannelSettings.STREAM_CODEC;
    }

    public MapCodec<? extends IConnectorSettings> getConnectorCodec() {
        return FluidConnectorSettings.CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ? extends IConnectorSettings> getConnectorStreamCodec() {
        return FluidConnectorSettings.STREAM_CODEC;
    }

    public boolean supportsBlock(@Nonnull Level world, @Nonnull BlockPos pos, @Nullable Direction side) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te == null) {
            return false;
        }
        return world.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)side) != null;
    }

    @Nonnull
    public IConnectorSettings createConnector(@Nonnull Direction side) {
        return new FluidConnectorSettings(side);
    }

    @Nonnull
    public IChannelSettings createChannel() {
        return new FluidChannelSettings();
    }
}

