/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.fluids;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.XNet;
import mcjty.xnet.apiimpl.ConnectedEntity;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.enums.ChannelMode;
import mcjty.xnet.apiimpl.enums.InsExtMode;
import mcjty.xnet.apiimpl.fluids.FluidConnectorSettings;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.setup.Config;
import mcjty.xnet.utils.CastTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)"textures/gui/guielements.png");
    private ChannelMode channelMode = ChannelMode.ROUNDROBIN;
    private int delay = 0;
    private int roundRobinOffset = 0;
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidChannelSettings> STREAM_CODEC = StreamCodec.composite(ChannelMode.STREAM_CODEC, FluidChannelSettings::getChannelMode, FluidChannelSettings::new);
    public static final MapCodec<FluidChannelSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChannelMode.CODEC.fieldOf("mode").forGetter(FluidChannelSettings::getChannelMode)).apply((Applicative)instance, FluidChannelSettings::new));
    private List<ConnectedEntity<FluidConnectorSettings>> fluidExtractors = null;
    private List<ConnectedEntity<FluidConnectorSettings>> fluidConsumers = null;

    public FluidChannelSettings() {
    }

    public FluidChannelSettings(ChannelMode channelMode) {
        this.channelMode = channelMode;
    }

    public ChannelMode getChannelMode() {
        return this.channelMode;
    }

    public IChannelType getType() {
        return XNet.setup.fluidChannelType;
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add("mode", (JsonElement)new JsonPrimitive(this.channelMode.name()));
        return object;
    }

    public void readFromJson(JsonObject data) {
        this.channelMode = EnumStringTranslators.getFluidChannelMode(data.get("mode").getAsString());
    }

    public void readFromNBT(CompoundTag tag) {
        this.delay = tag.getInt("delay");
        this.roundRobinOffset = tag.getInt("offset");
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putInt("delay", this.delay);
        tag.putInt("offset", this.roundRobinOffset);
    }

    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 != 0) {
            return;
        }
        int d = this.delay / 10;
        this.updateCache(channel, context);
        Level world = context.getControllerWorld();
        for (ConnectedEntity<FluidConnectorSettings> extractor : this.fluidExtractors) {
            IFluidHandler handler;
            FluidConnectorSettings settings = (FluidConnectorSettings)((Object)extractor.settings());
            if (d % settings.getSpeed() != 0 || !LevelTools.isLoaded((Level)world, (BlockPos)extractor.getBlockPos()) || !this.checkRedstone(settings, extractor.getConnectorEntity(), context) || (handler = FluidChannelSettings.getFluidHandlerAt(extractor.getConnectedEntity(), ((FluidConnectorSettings)((Object)extractor.settings())).getFacing())) == null) continue;
            this.tickFluidHandler(context, settings, handler);
        }
    }

    private void tickFluidHandler(IControllerContext context, FluidConnectorSettings settings, IFluidHandler handler) {
        FluidStack stack;
        int remaining;
        if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) {
            return;
        }
        FluidStack extractMatcher = settings.getMatcher();
        int toextract = settings.getRate();
        Integer count = settings.getMinmax();
        if (count != null) {
            int amount = this.countFluid(handler, extractMatcher);
            int canextract = amount - count;
            if (canextract <= 0) {
                return;
            }
            toextract = Math.min(toextract, canextract);
        }
        do {
            if ((stack = this.fetchFluid(handler, true, extractMatcher, toextract)).isEmpty()) {
                return;
            }
            toextract = stack.getAmount();
        } while ((remaining = this.insertFluid(context, stack)) == (toextract -= remaining));
        this.fetchFluid(handler, false, extractMatcher, toextract);
    }

    public void cleanCache() {
        this.fluidExtractors = null;
        this.fluidConsumers = null;
    }

    @Nonnull
    private FluidStack fetchFluid(IFluidHandler handler, boolean simulate, @Nullable FluidStack matcher, int rate) {
        IFluidHandler.FluidAction action;
        IFluidHandler.FluidAction fluidAction = action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        if (matcher == null || matcher.isEmpty()) {
            return handler.drain(rate, action);
        }
        matcher = matcher.copy();
        matcher.setAmount(rate);
        return handler.drain(matcher, action);
    }

    private int insertFluid(@Nonnull IControllerContext context, @Nonnull FluidStack stack) {
        Level world = context.getControllerWorld();
        if (this.channelMode == ChannelMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        int amount = stack.getAmount();
        for (int j = 0; j < this.fluidConsumers.size(); ++j) {
            FluidStack matcher;
            IFluidHandler destination;
            int i = (j + this.roundRobinOffset) % this.fluidConsumers.size();
            ConnectedEntity<FluidConnectorSettings> consumer = this.fluidConsumers.get(i);
            FluidConnectorSettings settings = (FluidConnectorSettings)((Object)consumer.settings());
            if (!LevelTools.isLoaded((Level)world, (BlockPos)consumer.getBlockPos()) || (destination = FluidChannelSettings.getFluidHandlerAt(consumer.getConnectedEntity(), ((FluidConnectorSettings)((Object)consumer.settings())).getFacing())) == null || (matcher = settings.getMatcher()) != null && !matcher.equals(stack) || !this.checkRedstone(settings, consumer.getConnectorEntity(), context)) continue;
            int toinsert = Math.min(settings.getRate(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                int a = this.countFluid(destination, settings.getMatcher());
                int caninsert = count - a;
                if (caninsert <= 0) continue;
                toinsert = Math.min(toinsert, caninsert);
            }
            FluidStack copy = stack.copy();
            copy.setAmount(toinsert);
            int filled = destination.fill(copy, IFluidHandler.FluidAction.EXECUTE);
            if (filled <= 0) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.fluidConsumers.size();
            if ((amount -= filled) > 0) continue;
            return 0;
        }
        return amount;
    }

    private int countFluid(IFluidHandler handler, @Nullable FluidStack matcher) {
        int cnt = 0;
        for (int i = 0; i < handler.getTanks(); ++i) {
            if (handler.getFluidInTank(i).isEmpty() || matcher != null && !matcher.equals(handler.getFluidInTank(i))) continue;
            cnt += handler.getFluidInTank(i).getAmount();
        }
        return cnt;
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.fluidExtractors == null) {
            ConnectedEntity<FluidConnectorSettings> connectedEntity;
            FluidConnectorSettings con;
            this.fluidExtractors = new ArrayList<ConnectedEntity<FluidConnectorSettings>>();
            this.fluidConsumers = new ArrayList<ConnectedEntity<FluidConnectorSettings>>();
            Level world = context.getControllerWorld();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                connectedEntity = this.getConnectedEntityInfo(context, entry, world, con = (FluidConnectorSettings)((Object)entry.getValue()));
                if (connectedEntity == null) continue;
                if (con.getFluidMode() == InsExtMode.EXT) {
                    this.fluidExtractors.add(connectedEntity);
                    continue;
                }
                this.fluidConsumers.add(connectedEntity);
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (FluidConnectorSettings)((Object)entry.getValue());
                if (con.getFluidMode() != InsExtMode.INS || (connectedEntity = this.getConnectedEntityInfo(context, entry, world, con)) == null) continue;
                this.fluidConsumers.add(connectedEntity);
            }
            this.fluidConsumers.sort((o1, o2) -> ((FluidConnectorSettings)((Object)((Object)((Object)o2.settings())))).getPriority().compareTo(((FluidConnectorSettings)((Object)((Object)((Object)o1.settings())))).getPriority()));
        }
    }

    @Nullable
    private ConnectedEntity<FluidConnectorSettings> getConnectedEntityInfo(IControllerContext context, Map.Entry<SidedConsumer, IConnectorSettings> entry, @Nonnull Level world, @Nonnull FluidConnectorSettings con) {
        BlockPos connectorPos = context.findConsumerPosition(entry.getKey().consumerId());
        if (connectorPos == null) {
            return null;
        }
        ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)world.getBlockEntity(connectorPos);
        if (connectorTileEntity == null) {
            return null;
        }
        BlockPos connectedBlockPos = connectorPos.relative(entry.getKey().side());
        BlockEntity connectedEntity = world.getBlockEntity(connectedBlockPos);
        if (connectedEntity == null) {
            return null;
        }
        return new ConnectedEntity<FluidConnectorSettings>(entry.getKey(), con, connectorPos, connectedBlockPos, connectedEntity, connectorTileEntity);
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 22, 80, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void createGui(IEditorGui gui) {
        gui.nl();
        gui.translatableChoices("mode", (ITranslatableEnum)this.channelMode, (ITranslatableEnum[])ChannelMode.values());
    }

    public void update(Map<String, Object> data) {
        this.channelMode = CastTools.safeChannelMode(data.get("mode"));
    }

    public int getColors() {
        return 0;
    }

    @Nullable
    public static IFluidHandler getFluidHandlerAt(@Nullable BlockEntity te, Direction intSide) {
        if (te != null) {
            return (IFluidHandler)te.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, te.getBlockPos(), (Object)intSide);
        }
        return null;
    }
}

