/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.ui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.client.render.PlayerFaceRenderer;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class RoomMetadataDebugOverlay
implements LayeredDraw.Layer {
    private static void drawRoomCode(GuiGraphics graphics, Minecraft mc, Player player, PoseStack poseStack, int center, int screenHeight) {
        player.getExistingData(Rooms.DataAttachments.CURRENT_ROOM_CODE).ifPresent(code -> graphics.drawCenteredString(mc.font, (Component)Component.literal((String)("Current Room: " + code)), 0, 0, -6250336));
    }

    private static void drawRoomOwnerInfo(GuiGraphics graphics, Minecraft mc, Player player, PoseStack poseStack, UUID owner) {
        PlayerUtil.getProfileByUUID((LevelAccessor)player.level(), owner).ifPresent(ownerInfo -> {
            PlayerFaceRenderer.render(ownerInfo, graphics, graphics.pose(), -6, -14);
            poseStack.translate(0.0f, 12.0f, 0.0f);
        });
    }

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.getDebugOverlay().showDebugScreen()) {
            return;
        }
        if (mc.player == null) {
            return;
        }
        if (!CompactDimension.isLevelCompact((Level)mc.player.level())) {
            return;
        }
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int center = screenWidth / 2;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)center, (float)(screenHeight - 75), 0.0f);
        RoomMetadataDebugOverlay.drawRoomCode(graphics, mc, (Player)mc.player, poseStack, center, screenHeight);
        poseStack.popPose();
    }
}

