/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.api.room.RoomInstance;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;

public class RoomBlocks {
    public static CompletableFuture<StructureTemplate> getInternalBlocks(MinecraftServer server, RoomInstance room) {
        StructureTemplate tem = new StructureTemplate();
        ServerLevel compactDim = server.getLevel(CompactDimension.LEVEL_KEY);
        ServerChunkCache chunkSource = compactDim.getChunkSource();
        List<CompletableFuture> chunkLoading = CompactMachines.roomApi().chunks(room.code()).stream().map(cp -> chunkSource.getChunkFuture(cp.x, cp.z, ChunkStatus.FULL, true)).toList();
        CompletableFuture<Void> awaitAllChunks = CompletableFuture.allOf(chunkLoading.toArray(new CompletableFuture[chunkLoading.size()]));
        return awaitAllChunks.thenApply(ignored -> {
            AABB bounds = room.boundaries().innerBounds();
            tem.fillFromWorld((Level)compactDim, BlockPos.containing((double)bounds.minX, (double)(bounds.minY - 1.0), (double)bounds.minZ), new Vec3i((int)bounds.getXsize(), (int)bounds.getYsize() + 1, (int)bounds.getZsize()), false, Blocks.AIR);
            return tem;
        });
    }
}

