/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.block;

import dev.compactmods.machines.api.machine.MachineColor;
import dev.compactmods.machines.api.machine.block.IUnboundCompactMachineBlockEntity;
import dev.compactmods.machines.machine.Machines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnboundCompactMachineEntity
extends BlockEntity
implements IUnboundCompactMachineBlockEntity {
    @Nullable
    private ResourceLocation templateId = null;

    public UnboundCompactMachineEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Machines.BlockEntities.UNBOUND_MACHINE.get(), pos, state);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.templateId = (ResourceLocation)components.get(Machines.DataComponents.ROOM_TEMPLATE_ID);
        MachineColor desiredColor = (MachineColor)components.get(Machines.DataComponents.MACHINE_COLOR);
        if (desiredColor != null) {
            this.setData(Machines.Attachments.MACHINE_COLOR, desiredColor);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(Machines.DataComponents.ROOM_TEMPLATE_ID, (Object)this.templateId);
        builder.set(Machines.DataComponents.MACHINE_COLOR, (Object)((MachineColor)this.getData(Machines.Attachments.MACHINE_COLOR)));
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("room_template");
        tag.remove("machine_color");
    }

    public void loadAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider holders) {
        super.loadAdditional(nbt, holders);
        if (nbt.contains("template_id")) {
            this.templateId = ResourceLocation.parse((String)nbt.getString("template_id"));
        }
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider holders) {
        super.saveAdditional(nbt, holders);
        if (this.templateId != null) {
            nbt.putString("template_id", this.templateId.toString());
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider holders) {
        CompoundTag data = super.getUpdateTag(holders);
        this.saveAdditional(data, holders);
        if (this.templateId != null) {
            data.putString("template_id", this.templateId.toString());
        }
        return data;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        if (tag.contains("template_id")) {
            this.templateId = ResourceLocation.parse((String)tag.getString("template_id"));
        }
    }

    public void setTemplate(ResourceLocation template) {
        this.templateId = template;
        this.setChanged();
    }

    @Nullable
    public ResourceLocation templateId() {
        return this.templateId;
    }
}

