/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.api.room.upgrade.RoomUpgrade;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeType;
import dev.compactmods.machines.api.room.upgrade.components.RoomUpgradeList;
import dev.compactmods.machines.command.argument.Suggestors;
import dev.compactmods.machines.feature.CMFeatureFlags;
import dev.compactmods.machines.room.upgrade.RoomUpgrades;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RoomUpgradesSubcommand {
    private static final Logger LOGGER = LoggingUtil.modLog();

    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = (LiteralArgumentBuilder)Commands.literal((String)"upgrades").requires(cs -> CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(cs.enabledFeatures()) && cs.hasPermission(2));
        subRoot.then(Commands.literal((String)"add").then(Commands.argument((String)"upgrade", (ArgumentType)ResourceLocationArgument.id()).suggests(Suggestors.ROOM_UPGRADE_TYPES).executes(RoomUpgradesSubcommand::applyUpgrade)));
        subRoot.then(Commands.literal((String)"remove").then(Commands.argument((String)"room", (ArgumentType)StringArgumentType.string()).suggests(Suggestors.ROOM_UPGRADE_TYPES).executes(RoomUpgradesSubcommand::removeUpgrade)));
        return subRoot;
    }

    @Nullable
    private static RoomUpgradeType<?> getTargetedUpgradeType(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ResourceLocation upgradeType = ResourceLocationArgument.getId(ctx, (String)"upgrade");
        return (RoomUpgradeType)src.getServer().registryAccess().registryOrThrow(RoomUpgradeType.REGISTRY_KEY).get(upgradeType);
    }

    private static int applyUpgrade(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        RoomUpgradeType<?> realUpgradeType = RoomUpgradesSubcommand.getTargetedUpgradeType(ctx);
        if (realUpgradeType == null) {
            return 0;
        }
        ItemStack heldItem = player.getMainHandItem();
        RoomUpgradeList currentUpgrades = (RoomUpgradeList)heldItem.get(RoomUpgrades.UPGRADE_LIST_COMPONENT);
        if (!realUpgradeType.canApplyTo(heldItem)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"That upgrade cannot be applied to the held item."));
            return 0;
        }
        if (currentUpgrades != null) {
            ArrayList<RoomUpgrade> addedList = new ArrayList<RoomUpgrade>(currentUpgrades.upgrades());
            addedList.add((RoomUpgrade)realUpgradeType.constructor().get());
            RoomUpgradeList newList = new RoomUpgradeList(addedList);
            heldItem.set(RoomUpgrades.UPGRADE_LIST_COMPONENT, (Object)newList);
        } else {
            RoomUpgradeList newList = new RoomUpgradeList(List.of((RoomUpgrade)realUpgradeType.constructor().get()));
            heldItem.set(RoomUpgrades.UPGRADE_LIST_COMPONENT, (Object)newList);
        }
        return 0;
    }

    private static int removeUpgrade(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        RoomUpgradeType<?> realUpgradeType = RoomUpgradesSubcommand.getTargetedUpgradeType(ctx);
        ItemStack heldItem = player.getMainHandItem();
        RoomUpgradeList currentUpgrades = (RoomUpgradeList)heldItem.get(RoomUpgrades.UPGRADE_LIST_COMPONENT);
        if (currentUpgrades != null) {
            RoomUpgradeList newList = new RoomUpgradeList(currentUpgrades.upgrades());
            newList.upgrades().removeIf(ru -> ru.getType().equals((Object)realUpgradeType));
            heldItem.set(RoomUpgrades.UPGRADE_LIST_COMPONENT, (Object)newList);
        }
        return 0;
    }
}

