/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.jetbrains.annotations.Nullable;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.structures.TFStructureComponentTemplate;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.SortablePiece;

public abstract class LandmarkStructure
extends Structure
implements DecorationClearance {
    protected final DecorationClearance.DecorationConfig decorationConfig;
    protected final boolean centerInChunk;
    protected Optional<Holder<MapDecorationType>> structureIcon;

    protected static <S extends LandmarkStructure> Products.P4<RecordCodecBuilder.Mu<S>, DecorationClearance.DecorationConfig, Boolean, Optional<Holder<MapDecorationType>>, Structure.StructureSettings> landmarkCodec(RecordCodecBuilder.Instance<S> instance) {
        return instance.group((App)DecorationClearance.DecorationConfig.FLAT_CODEC.forGetter(s -> s.decorationConfig), (App)Codec.BOOL.optionalFieldOf("center_in_chunk", (Object)true).forGetter(s -> s.centerInChunk), (App)BuiltInRegistries.MAP_DECORATION_TYPE.holderByNameCodec().optionalFieldOf("structure_icon").forGetter(s -> s.structureIcon), (App)Structure.settingsCodec(instance));
    }

    public LandmarkStructure(DecorationClearance.DecorationConfig decorationConfig, boolean centerInChunk, Optional<Holder<MapDecorationType>> structureIcon, Structure.StructureSettings structureSettings) {
        super(structureSettings);
        this.decorationConfig = decorationConfig;
        this.centerInChunk = centerInChunk;
        this.structureIcon = structureIcon;
    }

    protected Structure.GenerationStub getStructurePieceGenerationStubFunction(StructurePiece startingPiece, Structure.GenerationContext context, int x, int y, int z) {
        return new Structure.GenerationStub(new BlockPos(x, y, z), structurePiecesBuilder -> {
            this.generateFromStartingPiece(startingPiece, context, (StructurePiecesBuilder)structurePiecesBuilder);
            structurePiecesBuilder.pieces.sort(Comparator.comparing(piece -> {
                Integer n;
                if (piece instanceof SortablePiece) {
                    SortablePiece sortable = (SortablePiece)piece;
                    n = sortable.getSortKey();
                } else {
                    n = 0;
                }
                return n;
            }));
            structurePiecesBuilder.pieces.stream().filter(TFStructureComponentTemplate.class::isInstance).map(TFStructureComponentTemplate.class::cast).forEach(t -> t.LAZY_TEMPLATE_LOADER.run());
        });
    }

    protected void generateFromStartingPiece(StructurePiece startingPiece, Structure.GenerationContext context, StructurePiecesBuilder structurePiecesBuilder) {
        structurePiecesBuilder.addPiece(startingPiece);
        startingPiece.addChildren(startingPiece, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)context.random());
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        int x = (chunkPos.x << 4) + (this.centerInChunk ? 7 : 0);
        int z = (chunkPos.z << 4) + (this.centerInChunk ? 7 : 0);
        int y = this.adjustForTerrain(context, x, z);
        return Optional.ofNullable(this.getFirstPiece(context, RandomSource.create((long)(context.seed() + (long)chunkPos.x * 25117L + (long)chunkPos.z * 151121L)), chunkPos, x, y, z)).map(piece -> this.getStructurePieceGenerationStubFunction((StructurePiece)piece, context, x, y, z));
    }

    public final Optional<Holder<MapDecorationType>> getMapIcon() {
        return this.structureIcon;
    }

    @Nullable
    protected abstract StructurePiece getFirstPiece(Structure.GenerationContext var1, RandomSource var2, ChunkPos var3, int var4, int var5, int var6);

    @Override
    public boolean isSurfaceDecorationsAllowed() {
        return this.decorationConfig.surfaceDecorations();
    }

    @Override
    public boolean isUndergroundDecoAllowed() {
        return this.decorationConfig.undergroundDecorations();
    }

    @Override
    public boolean isGrassDecoAllowed() {
        return this.decorationConfig.vegetation();
    }

    @Override
    public boolean shouldAdjustToTerrain() {
        return this.decorationConfig.adjustElevation();
    }

    @Override
    public float chunkClearanceRadius() {
        return this.decorationConfig.chunkClearanceRadius();
    }

    public Optional<Structure.GenerationStub> findValidGenerationPoint(Structure.GenerationContext context) {
        BiomeSource biomeSource = context.biomeSource();
        if (!(biomeSource instanceof TFBiomeProvider)) {
            return super.findValidGenerationPoint(context);
        }
        TFBiomeProvider twilightBiomeProvider = (TFBiomeProvider)biomeSource;
        ChunkPos chunkPos = context.chunkPos();
        int biomeX = (Math.round((float)chunkPos.x / 16.0f) << 6) + 2;
        int biomeZ = (Math.round((float)chunkPos.z / 16.0f) << 6) + 2;
        Holder<Biome> biomeAt = twilightBiomeProvider.getMainBiome(biomeX, biomeZ);
        return context.validBiome().test(biomeAt) ? this.findGenerationPoint(context) : Optional.empty();
    }
}

