/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.stronghold;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.stronghold.KnightStrongholdComponent;
import twilightforest.world.components.structures.stronghold.StrongholdAccessChamberComponent;
import twilightforest.world.components.structures.stronghold.StrongholdBossRoomComponent;
import twilightforest.world.components.structures.stronghold.StrongholdDecorator;
import twilightforest.world.components.structures.stronghold.StrongholdPieces;

public class StrongholdEntranceComponent
extends KnightStrongholdComponent {
    public final StrongholdPieces lowerPieces;

    public StrongholdEntranceComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFSEnter.get(), nbt);
        this.deco = new StrongholdDecorator();
        this.lowerPieces = new StrongholdPieces();
    }

    public StrongholdEntranceComponent(int i, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFSEnter.get(), i, Direction.SOUTH, x, y - 10, z);
        this.deco = new StrongholdDecorator();
        this.lowerPieces = new StrongholdPieces();
    }

    @Override
    public void addChildren(StructurePiece parent, StructurePieceAccessor old, RandomSource random) {
        super.addChildren(parent, old, random);
        if (old instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)old;
            List list = start.pieces;
            this.lowerPieces.prepareStructurePieces();
            this.addNewComponent(parent, old, random, Rotation.NONE, 4, 1, 18);
            this.lowerPieces.prepareStructurePieces();
            if (this.listContainsBossRoom(list)) {
                this.lowerPieces.markBossRoomUsed();
            }
            this.addNewComponent(parent, old, random, Rotation.CLOCKWISE_90, -1, 1, 13);
            this.lowerPieces.prepareStructurePieces();
            if (this.listContainsBossRoom(list)) {
                this.lowerPieces.markBossRoomUsed();
            }
            this.addNewComponent(parent, old, random, Rotation.CLOCKWISE_180, 13, 1, -1);
            this.lowerPieces.prepareStructurePieces();
            if (this.listContainsBossRoom(list)) {
                this.lowerPieces.markBossRoomUsed();
            }
            this.addNewComponent(parent, old, random, Rotation.COUNTERCLOCKWISE_90, 18, 1, 4);
            if (!this.listContainsBossRoom(list)) {
                TwilightForestMod.LOGGER.fatal("Did not find boss room from exit 3 - EPIC FAIL");
            }
            StrongholdAccessChamberComponent accessChamber = new StrongholdAccessChamberComponent(2, this.getOrientation(), this.boundingBox.minX() + 8, this.boundingBox.minY() + 7, this.boundingBox.minZ() + 4);
            list.add(accessChamber);
            ((KnightStrongholdComponent)accessChamber).addChildren(this, old, random);
        }
    }

    private boolean listContainsBossRoom(List<StructurePiece> list) {
        for (StructurePiece component : list) {
            if (!(component instanceof StrongholdBossRoomComponent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BoundingBox generateBoundingBox(Direction facing, int x, int y, int z) {
        return BoundingBox.orientBox((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)18, (int)7, (int)18, (Direction)facing);
    }

    public void postProcess(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.placeStrongholdWalls(world, sbb, 0, 0, 0, 17, 6, 17, rand, this.deco.randomBlocks);
        this.placeCornerStatue(world, 5, 1, 5, 0, sbb);
        this.placeCornerStatue(world, 5, 1, 12, 1, sbb);
        this.placeCornerStatue(world, 12, 1, 5, 2, sbb);
        this.placeCornerStatue(world, 12, 1, 12, 3, sbb);
        this.placeWallStatue(world, 9, 1, 16, Rotation.NONE, sbb);
        this.placeWallStatue(world, 1, 1, 9, Rotation.CLOCKWISE_90, sbb);
        this.placeWallStatue(world, 8, 1, 1, Rotation.CLOCKWISE_180, sbb);
        this.placeWallStatue(world, 16, 1, 8, Rotation.COUNTERCLOCKWISE_90, sbb);
        this.placeDoors(world, sbb);
    }
}

