/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.util.RootPlacer;
import twilightforest.util.features.FeaturePlacers;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.SnowTreeFeature;
import twilightforest.world.components.feature.trees.TFTreeFeature;

public class LargeWinterTreeFeature
extends TFTreeFeature<TFTreeFeatureConfig> {
    public LargeWinterTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RootPlacer decorationPlacer, TFTreeFeatureConfig config) {
        int treeHeight = 35;
        if (random.nextInt(3) == 0) {
            treeHeight += random.nextInt(10);
            if (random.nextInt(8) == 0) {
                treeHeight += random.nextInt(10);
            }
        }
        if (world.isOutsideBuildHeight(pos.getY() + treeHeight)) {
            return false;
        }
        if (!SnowTreeFeature.validTreePos((LevelSimulatedReader)world, pos)) {
            return false;
        }
        this.buildTrunk((LevelAccessor)world, trunkPlacer, random, pos, treeHeight, config);
        this.makeLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos, treeHeight, config);
        int numRoots = 4 + random.nextInt(3);
        float offset = random.nextFloat();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot((LevelAccessor)world, decorationPlacer, random, pos, offset, b, config.rootsProvider);
        }
        return true;
    }

    private void makeLeaves(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource random, BlockPos pos, int treeHeight, TFTreeFeatureConfig config) {
        int offGround = 3;
        int leafType = 1;
        for (int dy = 0; dy < treeHeight; ++dy) {
            int radius = this.leafRadius(treeHeight, dy, leafType);
            FeaturePlacers.placeCircleEven((LevelSimulatedReader)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, pos.above(offGround + treeHeight - dy), radius, config.leavesProvider);
            this.makePineBranches(world, trunkPlacer, random, pos.above(offGround + treeHeight - dy), radius, config);
        }
    }

    private void makePineBranches(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, RandomSource rand, BlockPos pos, int radius, TFTreeFeatureConfig config) {
        int branchLength = radius > 4 ? radius - 1 : radius - 2;
        switch (pos.getY() % 2) {
            case 0: {
                for (int i = 1; i <= branchLength; ++i) {
                    this.placeLogAt(trunkPlacer, rand, pos.offset(-i, 0, 0), Direction.Axis.X, config);
                    this.placeLogAt(trunkPlacer, rand, pos.offset(0, 0, i + 1), Direction.Axis.Z, config);
                    this.placeLogAt(trunkPlacer, rand, pos.offset(i + 1, 0, 1), Direction.Axis.X, config);
                    this.placeLogAt(trunkPlacer, rand, pos.offset(1, 0, -i), Direction.Axis.Z, config);
                }
                break;
            }
            case 1: {
                for (int i = 1; i <= branchLength; ++i) {
                    this.placeLogAt(trunkPlacer, rand, pos.offset(-1, 0, 1), Direction.Axis.X, config);
                    this.placeLogAt(trunkPlacer, rand, pos.offset(1, 0, i + 1), Direction.Axis.Z, config);
                    this.placeLogAt(trunkPlacer, rand, pos.offset(i + 1, 0, 0), Direction.Axis.X, config);
                    this.placeLogAt(trunkPlacer, rand, pos.offset(0, 0, -i), Direction.Axis.Z, config);
                }
                break;
            }
        }
    }

    private void placeLogAt(BiConsumer<BlockPos, BlockState> trunkPlacer, RandomSource rand, BlockPos pos, Direction.Axis axis, TFTreeFeatureConfig config) {
        trunkPlacer.accept(pos, (BlockState)config.trunkProvider.getState(rand, pos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis));
    }

    private int leafRadius(int treeHeight, int dy, int functionType) {
        return switch (functionType) {
            case 1 -> (int)(4.0f * (float)dy / (float)treeHeight + 0.75f * (float)dy % 3.0f);
            case 99 -> (treeHeight - dy / 2 - 1) % 4;
            default -> (dy - 1) % 4;
        };
    }

    private void buildTrunk(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, RandomSource rand, BlockPos pos, int treeHeight, TFTreeFeatureConfig config) {
        for (int dy = 0; dy < treeHeight; ++dy) {
            if (FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos.offset(0, dy, 0), config.trunkProvider) && dy == 0) {
                world.setBlock(pos.offset(0, -1, 0), Blocks.DIRT.defaultBlockState(), 19);
            }
            if (FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos.offset(0, dy, 1), config.trunkProvider) && dy == 0) {
                world.setBlock(pos.offset(0, -1, 1), Blocks.DIRT.defaultBlockState(), 19);
            }
            if (FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos.offset(1, dy, 0), config.trunkProvider) && dy == 0) {
                world.setBlock(pos.offset(1, -1, 0), Blocks.DIRT.defaultBlockState(), 19);
            }
            if (!FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos.offset(1, dy, 1), config.trunkProvider) || dy != 0) continue;
            world.setBlock(pos.offset(1, -1, 1), Blocks.DIRT.defaultBlockState(), 19);
        }
    }
}

