/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import twilightforest.init.TFBlocks;
import twilightforest.util.features.FeatureLogic;
import twilightforest.util.iterators.VoxelBresenhamIterator;

@ParametersAreNonnullByDefault
public abstract class CanopyMushroomFeature
extends AbstractHugeMushroomFeature {
    public CanopyMushroomFeature(Codec<HugeMushroomFeatureConfiguration> featureConfigurationCodec) {
        super(featureConfigurationCodec);
    }

    protected int getTreeRadiusForHeight(int i, int i1, int foliageRadius, int treeHeight) {
        return treeHeight <= 3 ? 0 : (int)((float)foliageRadius * 1.5f);
    }

    protected void placeTrunk(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, HugeMushroomFeatureConfiguration featureConfiguration, int height, BlockPos.MutableBlockPos mutableBlockPos) {
        int bugsLeft = Math.max(0, random.nextInt(10) - 4) / 2;
        for (int i = 0; i < height; ++i) {
            mutableBlockPos.set((Vec3i)pos).move(Direction.UP, i);
            if (!levelAccessor.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) {
                this.setBlock((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, featureConfiguration.stemProvider.getState(random, pos));
                if (bugsLeft <= 0 || i <= height / 2 || random.nextInt(10) != 9 || !this.addFirefly(levelAccessor, (BlockPos)mutableBlockPos, random)) continue;
                --bugsLeft;
                continue;
            }
            height = i;
            break;
        }
        int numBranches = this.getBranches(random);
        float offset = random.nextFloat();
        for (int b = 0; b < numBranches; ++b) {
            bugsLeft = this.buildABranch(levelAccessor, pos, height - 6 + b, this.getLength(random), 0.3 * (double)b + (double)offset, random, new HugeMushroomFeatureConfiguration(featureConfiguration.capProvider, featureConfiguration.stemProvider, featureConfiguration.foliageRadius - 1), bugsLeft);
        }
    }

    protected boolean addFirefly(LevelAccessor levelAccessor, BlockPos pos, RandomSource random) {
        Direction direction = Direction.getRandom((RandomSource)random);
        if (direction.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BlockPos.MutableBlockPos bugPos = new BlockPos.MutableBlockPos();
        bugPos.set((Vec3i)pos).move(direction);
        if (levelAccessor.getBlockState((BlockPos)bugPos).isSolidRender((BlockGetter)levelAccessor, (BlockPos)bugPos)) {
            return false;
        }
        BlockState bugState = (BlockState)((Block)TFBlocks.FIREFLY.get()).defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)direction);
        this.setBlock((LevelWriter)levelAccessor, (BlockPos)bugPos, bugState);
        return true;
    }

    protected int getTreeHeight(RandomSource random) {
        return 9 + random.nextInt(5);
    }

    protected abstract int getBranches(RandomSource var1);

    protected abstract double getLength(RandomSource var1);

    private int buildABranch(LevelAccessor levelAccessor, BlockPos pos, int height, double length, double angle, RandomSource random, HugeMushroomFeatureConfiguration featureConfiguration, int bugsLeft) {
        BlockState blockstate;
        BlockPos src = pos.above(height);
        BlockPos dest = FeatureLogic.translate(src, length, angle, 0.2);
        for (BlockPos pixel : new VoxelBresenhamIterator(src, new BlockPos(dest.getX(), src.getY(), dest.getZ()))) {
            blockstate = featureConfiguration.stemProvider.getState(random, pos);
            if (blockstate.hasProperty((Property)HugeMushroomBlock.UP) && blockstate.hasProperty((Property)HugeMushroomBlock.DOWN)) {
                blockstate = (BlockState)((BlockState)blockstate.setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(true));
            }
            this.setBlock((LevelWriter)levelAccessor, pixel, blockstate);
        }
        int max = Math.max(src.getY(), dest.getY());
        for (int i = Math.min(src.getY(), dest.getY()); i < max + 1; ++i) {
            blockstate = featureConfiguration.stemProvider.getState(random, pos);
            if (blockstate.hasProperty((Property)HugeMushroomBlock.DOWN) && i == Math.min(src.getY(), dest.getY())) {
                blockstate = (BlockState)blockstate.setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(true));
            }
            BlockPos blockPos = new BlockPos(dest.getX(), i, dest.getZ());
            this.setBlock((LevelWriter)levelAccessor, blockPos, blockstate);
            if (bugsLeft <= 0 || i <= Math.min(src.getY(), dest.getY()) / 2 || random.nextInt(20) != 0 || !this.addFirefly(levelAccessor, blockPos, random)) continue;
            --bugsLeft;
        }
        this.makeCap(levelAccessor, random, dest, 1, new BlockPos.MutableBlockPos(), featureConfiguration);
        return bugsLeft;
    }

    protected void makeCap(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        int foliageRadius = featureConfiguration.foliageRadius;
        for (int x = -foliageRadius; x <= foliageRadius; ++x) {
            for (int z = -foliageRadius; z <= foliageRadius; ++z) {
                if (FeatureLogic.isCornerInSquare(x, z, foliageRadius)) continue;
                mutableBlockPos.setWithOffset((Vec3i)pos, x, height, z);
                if (levelAccessor.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)levelAccessor, (BlockPos)mutableBlockPos)) continue;
                BlockState blockState = featureConfiguration.capProvider.getState(random, pos);
                blockState = FeatureLogic.getHorizontalMushroomBlockState(blockState, x, z, foliageRadius);
                this.setBlock((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockState);
            }
        }
    }
}

