/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import twilightforest.init.TFBlocks;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.feature.config.ThornsConfig;

public class ThornFeature
extends Feature<ThornsConfig> {
    public ThornFeature(Codec<ThornsConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<ThornsConfig> ctx) {
        WorldGenLevel world = ctx.level();
        BlockPos pos = ctx.origin();
        RandomSource rand = ctx.random();
        int nextLength = 2 + rand.nextInt(4);
        int maxLength = 2 + rand.nextInt(4) + rand.nextInt(4) + rand.nextInt(4);
        this.placeThorns(world, rand, pos, nextLength, Direction.UP, maxLength, pos, (ThornsConfig)ctx.config(), true);
        return true;
    }

    private void placeThorns(WorldGenLevel world, RandomSource rand, BlockPos pos, int length, Direction dir, int maxLength, BlockPos oPos, ThornsConfig config, boolean avoidGiantCloud) {
        Direction nextDir;
        int middle;
        boolean complete = false;
        for (int i = 0; i < length; ++i) {
            BlockPos dPos = pos.relative(dir, i);
            if (avoidGiantCloud && !ThornFeature.checkIsUnderCloud(world, pos, dPos) || Math.abs(dPos.getX() - oPos.getX()) >= config.maxSpread() || Math.abs(dPos.getZ() - oPos.getZ()) >= config.maxSpread() || !this.canPlaceThorns((LevelAccessor)world, dPos)) break;
            world.setBlock(dPos, (BlockState)((Block)TFBlocks.BROWN_THORNS.get()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis()), 2);
            world.getChunk(dPos).markPosForPostprocessing(dPos);
            if (i != length - 1) continue;
            complete = true;
            if (rand.nextInt(config.chanceOfLeaf()) != 0 || !world.isEmptyBlock(dPos.relative(dir))) continue;
            if (rand.nextInt(config.chanceLeafIsRose()) > 0) {
                world.setBlock(dPos.relative(dir), (BlockState)((Block)TFBlocks.THORN_LEAVES.get()).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 3);
                continue;
            }
            world.setBlock(dPos.relative(dir), (BlockState)((Block)TFBlocks.THORN_ROSE.get()).defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)dir), 3);
        }
        if (complete && maxLength > 1) {
            Direction nextDir2 = Direction.getRandom((RandomSource)rand);
            BlockPos nextPos = pos.relative(dir, length - 1).relative(nextDir2);
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir2, maxLength - 1, oPos, config, false);
        }
        if (complete && length > 3 && rand.nextInt(config.chanceOfBranch()) == 0) {
            middle = rand.nextInt(length);
            nextDir = Direction.getRandom((RandomSource)rand);
            BlockPos nextPos = pos.relative(dir, middle).relative(nextDir);
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir, maxLength - 1, oPos, config, false);
        }
        if (complete && length > 3 && rand.nextInt(config.chanceOfLeaf()) == 0) {
            middle = rand.nextInt(length);
            nextDir = Direction.getRandom((RandomSource)rand);
            BlockPos nextPos = pos.relative(dir, middle).relative(nextDir);
            if (world.isEmptyBlock(nextPos)) {
                world.setBlock(nextPos, (BlockState)((Block)TFBlocks.THORN_LEAVES.get()).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 3);
            }
        }
    }

    private static boolean checkIsUnderCloud(WorldGenLevel world, BlockPos pos, BlockPos dPos) {
        return world.hasChunk(pos.getX() >> 4, pos.getZ() >> 4) && Math.max(dPos.getY(), world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dPos.getX(), dPos.getZ())) <= WorldUtil.getGeneratorSeaLevel((LevelAccessor)world) + 150;
    }

    private boolean canPlaceThorns(LevelAccessor world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.isAir() || state.is(BlockTags.LEAVES);
    }
}

