/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record TanhHillFunction(float centerX, float bottomY, float centerZ, float radius, float heightScale, float cosAngleBiasDirection, float sinAngleBiasDirection, boolean isXOriented, boolean isOnRightSide) implements DensityFunction.SimpleFunction
{
    public static final MapCodec<TanhHillFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("x_center").forGetter(TanhHillFunction::centerX), (App)Codec.FLOAT.fieldOf("y_bottom").forGetter(TanhHillFunction::bottomY), (App)Codec.FLOAT.fieldOf("z_center").forGetter(TanhHillFunction::centerZ), (App)Codec.FLOAT.fieldOf("radius").forGetter(TanhHillFunction::radius), (App)Codec.FLOAT.fieldOf("height_scale").forGetter(TanhHillFunction::heightScale), (App)Codec.FLOAT.fieldOf("cos_angle_bias_direction").forGetter(TanhHillFunction::cosAngleBiasDirection), (App)Codec.FLOAT.fieldOf("sin_angle_bias_direction").forGetter(TanhHillFunction::sinAngleBiasDirection), (App)Codec.BOOL.fieldOf("is_x_oriented").forGetter(TanhHillFunction::isXOriented), (App)Codec.BOOL.fieldOf("is_on_right_side").forGetter(TanhHillFunction::isOnRightSide)).apply((Applicative)instance, TanhHillFunction::new));
    public static final KeyDispatchDataCodec<TanhHillFunction> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    private static final float PERPENDICULAR_BIAS = 1.3f;

    public TanhHillFunction(float centerX, float bottomY, float centerZ, float radius, float heightScale, float angleBiasDirection, boolean isXOriented, boolean isOnRightSide) {
        this(centerX, bottomY, centerZ, radius, heightScale, Mth.cos((float)angleBiasDirection), Mth.sin((float)angleBiasDirection), isXOriented, isOnRightSide);
    }

    public double compute(DensityFunction.FunctionContext context) {
        float dX = (float)context.blockX() - this.centerX;
        float dY = (float)context.blockY() - this.bottomY;
        float dZ = (float)context.blockZ() - this.centerZ;
        if (this.isXOriented) {
            dZ *= 1.3f;
        } else {
            dX *= 1.3f;
        }
        return this.compute(dX, dY, dZ);
    }

    public double compute(float dX, float dY, float dZ) {
        double sin2Phi;
        double height;
        double sinPhi;
        double cosPhi;
        float perpendicularDist;
        if (dY > 10.0f || dY < -10.0f) {
            return -1.0;
        }
        float f = perpendicularDist = this.isXOriented ? dZ : dX;
        if (!this.isOnRightSide) {
            perpendicularDist = -perpendicularDist;
        }
        if (perpendicularDist < 0.0f) {
            return -1.0;
        }
        double distSquared = dX * dX + dZ * dZ;
        if (distSquared > (double)(9.0f * this.radius * this.radius)) {
            return -1.0;
        }
        double dist = Math.sqrt(distSquared);
        double cos2Phi = cosPhi * cosPhi - sinPhi * sinPhi;
        if ((double)this.heightScale * ((height = this.getHeight(dist /= 1.0 + ((sin2Phi = 2.0 * (cosPhi = (double)dX / dist) * (sinPhi = (double)dZ / dist)) * (double)this.cosAngleBiasDirection - cos2Phi * (double)this.sinAngleBiasDirection) / 3.0)) + 1.0) > (double)dY) {
            return 1.0;
        }
        return -1.0;
    }

    private double getHeight(double dist) {
        double tanhExp = Math.exp(2.0 * (2.0 - 2.0 * dist / (double)this.radius));
        double height = (tanhExp - 1.0) / (tanhExp + 1.0) - dist * (1.0 - Math.exp(-dist * (double)this.radius * 0.01));
        return height;
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return KEY_CODEC;
    }
}

