/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkblanketing;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import twilightforest.world.components.chunkblanketing.ChunkBlanketType;

public interface ChunkBlanketProcessor {
    public HolderSet<Biome> biomesForApplication();

    public void processChunk(RandomSource var1, Function<BlockPos, Holder<Biome>> var2, ChunkAccess var3);

    public ChunkBlanketType getType();

    public static interface SimpleProcessor
    extends ChunkBlanketProcessor {
        @Override
        default public void processChunk(RandomSource random, Function<BlockPos, Holder<Biome>> biomeGetter, ChunkAccess chunkAccess) {
            for (int dX = 0; dX < 16; ++dX) {
                for (int dZ = 0; dZ < 16; ++dZ) {
                    BlockPos firstAvailableBlock = chunkAccess.getPos().getBlockAt(dX, chunkAccess.getHeight(this.heightmap(), dX, dZ) + 1, dZ);
                    if (!this.biomesForApplication().contains(biomeGetter.apply(firstAvailableBlock))) continue;
                    this.processColumn(random, chunkAccess, firstAvailableBlock);
                }
            }
        }

        public void processColumn(RandomSource var1, ChunkAccess var2, BlockPos var3);

        public Heightmap.Types heightmap();
    }
}

