/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.features;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.event.EventHooks;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.init.TFBlocks;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.util.RootPlacer;
import twilightforest.util.features.FeatureLogic;
import twilightforest.util.features.FeatureUtil;
import twilightforest.util.iterators.VoxelBresenhamIterator;

public final class FeaturePlacers {
    public static final BiFunction<LevelSimulatedReader, BlockPos, Boolean> VALID_TREE_POS = TreeFeature::validTreePos;

    public static <T extends Mob> void placeEntity(EntityType<T> entityType, BlockPos pos, ServerLevelAccessor levelAccessor) {
        Mob mob = (Mob)entityType.create((Level)levelAccessor.getLevel());
        if (mob == null) {
            return;
        }
        mob.setPersistenceRequired();
        mob.moveTo(pos, 0.0f, 0.0f);
        EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)levelAccessor, (DifficultyInstance)levelAccessor.getCurrentDifficultyAt(pos), (MobSpawnType)MobSpawnType.STRUCTURE, null);
        if (mob instanceof EnforcedHomePoint) {
            EnforcedHomePoint home = (EnforcedHomePoint)mob;
            home.setRestrictionPoint(GlobalPos.of((ResourceKey)levelAccessor.getLevel().dimension(), (BlockPos)pos));
        }
        levelAccessor.addFreshEntityWithPassengers((Entity)mob);
        levelAccessor.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
    }

    public static void drawBresenhamBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, RandomSource random, BlockPos start, BlockPos end, BlockStateProvider config) {
        for (BlockPos pixel : new VoxelBresenhamIterator(start, end)) {
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pixel, config);
        }
    }

    public static void buildRoot(LevelAccessor world, RootPlacer placer, RandomSource rand, BlockPos start, double offset, int b, BlockStateProvider config) {
        BlockPos dest = FeatureLogic.translate(start.below(b + 2), 5.0, 0.3 * (double)b + offset, 0.8);
        for (BlockPos coord : new VoxelBresenhamIterator(start.below(), dest)) {
            if (FeaturePlacers.placeIfValidRootPos((LevelSimulatedReader)world, placer, rand, coord, config)) continue;
            return;
        }
    }

    public static void drawBresenhamTree(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos from, BlockPos to, BlockStateProvider config, RandomSource random) {
        for (BlockPos pixel : new VoxelBresenhamIterator(from, to)) {
            FeaturePlacers.placeProvidedBlock(world, placer, predicate, pixel, config, random);
        }
    }

    public static void placeProvidedBlock(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> worldPlacer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos pos, BlockStateProvider config, RandomSource random) {
        if (predicate.apply(world, pos).booleanValue()) {
            worldPlacer.accept(pos, config.getState(random, pos));
        }
    }

    public static void placeLeaf(LevelSimulatedReader world, FoliagePlacer.FoliageSetter setter, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos pos, BlockStateProvider config, RandomSource random) {
        if (predicate.apply(world, pos).booleanValue()) {
            setter.set(pos, config.getState(random, pos));
        }
    }

    public static void placeCircleOdd(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float radius, BlockStateProvider config) {
        FeaturePlacers.placeCircleOdd(world, placer, predicate, random, centerPos, radius, config, false);
    }

    public static void placeCircleOdd(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float radius, BlockStateProvider config, boolean useLegacyDistance) {
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int x = 0;
        while ((float)x <= radius) {
            int z = 1;
            while ((float)z <= radius) {
                if (FeaturePlacers.isWithinCircle(x, z, radius, useLegacyDistance)) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(x, 0, z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-z, 0, x), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(z, 0, -x), config, random);
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeCircleEven(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float radius, BlockStateProvider config) {
        FeaturePlacers.placeCircleEven(world, placer, predicate, random, centerPos, radius, config, false);
    }

    public static void placeCircleEven(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float radius, BlockStateProvider config, boolean useLegacyDistance) {
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int x = 0;
        while ((float)x <= radius) {
            int z = 0;
            while ((float)z <= radius) {
                if (FeaturePlacers.isWithinCircle(x, z, radius, useLegacyDistance)) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(1 + x, 0, 1 + z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-x, 0, 1 + z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(1 + x, 0, -z), config, random);
                }
                ++z;
            }
            ++x;
        }
    }

    public static boolean isWithinCircle(int x, int z, float radius, boolean useLegacyDistance) {
        if (useLegacyDistance) {
            int absX = Math.abs(x);
            int absZ = Math.abs(z);
            int legacyDistance = absX == 3 && absZ == 3 ? 6 : (int)((float)Math.max(absX, absZ) + (float)Math.min(absX, absZ) * 0.5f);
            return (float)legacyDistance <= radius;
        }
        return (float)(x * x + z * z) <= radius * radius;
    }

    public static void placeSpheroid(LevelSimulatedReader world, FoliagePlacer.FoliageSetter setter, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float xzRadius, float yRadius, float verticalBias, BlockStateProvider config) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeaturePlacers.placeLeaf(world, setter, predicate, centerPos, config, random);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(0, y, 0), config, random);
                FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(0, -y, 0), config, random);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(x, 0, z), config, random);
                    FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(-x, 0, -z), config, random);
                    FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(-z, 0, x), config, random);
                    FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(z, 0, -x), config, random);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + ((float)y2 - verticalBias) * ((float)y2 - verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(x, y2, z), config, random);
                            FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(-x, y2, -z), config, random);
                            FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(-z, y2, x), config, random);
                            FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(z, y2, -x), config, random);
                        }
                        if (xzSquare + ((float)y2 + verticalBias) * ((float)y2 + verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(x, -y2, z), config, random);
                            FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(-x, -y2, -z), config, random);
                            FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(-z, -y2, x), config, random);
                            FeaturePlacers.placeLeaf(world, setter, predicate, centerPos.offset(z, -y2, -x), config, random);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeSpheroid(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float xzRadius, float yRadius, BlockStateProvider config) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(0, y, 0), config, random);
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(0, -y, 0), config, random);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(x, 0, z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-z, 0, x), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(z, 0, -x), config, random);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float ySquare = (float)(y2 * y2) * xzRadiusSquared;
                        if ((float)(x * x + z * z) * yRadiusSquared + ySquare <= superRadiusSquared) {
                            if ((float)((x + 1) * (x + 1) + z * z) * yRadiusSquared + ySquare > superRadiusSquared && (float)(x * x + (z + 1) * (z + 1)) * yRadiusSquared + ySquare > superRadiusSquared) {
                                if (random.nextInt(3) != 0) {
                                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(x, y2, z), config, random);
                                }
                                if (random.nextInt(3) != 0) {
                                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-x, y2, -z), config, random);
                                }
                                if (random.nextInt(3) != 0) {
                                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-z, y2, x), config, random);
                                }
                                if (random.nextInt(3) != 0) {
                                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(z, y2, -x), config, random);
                                }
                                if (random.nextInt(3) != 0) {
                                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(x, -y2, z), config, random);
                                }
                                if (random.nextInt(3) != 0) {
                                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-x, -y2, -z), config, random);
                                }
                                if (random.nextInt(3) != 0) {
                                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-z, -y2, x), config, random);
                                }
                                if (random.nextInt(3) != 0) {
                                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(z, -y2, -x), config, random);
                                }
                            } else {
                                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(x, y2, z), config, random);
                                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-x, y2, -z), config, random);
                                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-z, y2, x), config, random);
                                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(z, y2, -x), config, random);
                                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(x, -y2, z), config, random);
                                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-x, -y2, -z), config, random);
                                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(-z, -y2, x), config, random);
                                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.offset(z, -y2, -x), config, random);
                            }
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static boolean placeIfValidTreePos(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, RandomSource random, BlockPos pos, BlockStateProvider config) {
        if (FeaturePlacers.validTreePos(world, pos)) {
            placer.accept(pos, config.getState(random, pos));
            return true;
        }
        return false;
    }

    public static boolean placeIfValidRootPos(LevelSimulatedReader world, RootPlacer placer, RandomSource random, BlockPos pos, BlockStateProvider config) {
        if (!FeatureUtil.anyBelowMatch(pos, placer.getRootPenetrability() - 1, blockPos -> !FeatureLogic.canRootGrowIn(world, blockPos))) {
            placer.getPlacer().accept(pos, config.getState(random, pos));
            return true;
        }
        return false;
    }

    public static boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos) || world.isStateAtPosition(pos, state -> state.is(BlockTags.FLOWERS));
    }

    public static void addFirefly(LevelAccessor world, BlockPos pos, int height, double angle) {
        int iAngle = (int)(angle * 4.0);
        if (iAngle == 0) {
            FeaturePlacers.setIfEmpty(world, pos.offset(1, height, 0), (BlockState)((Block)TFBlocks.FIREFLY.get()).defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.EAST));
        } else if (iAngle == 1) {
            FeaturePlacers.setIfEmpty(world, pos.offset(-1, height, 0), (BlockState)((Block)TFBlocks.FIREFLY.get()).defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.WEST));
        } else if (iAngle == 2) {
            FeaturePlacers.setIfEmpty(world, pos.offset(0, height, 1), (BlockState)((Block)TFBlocks.FIREFLY.get()).defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.SOUTH));
        } else if (iAngle == 3) {
            FeaturePlacers.setIfEmpty(world, pos.offset(0, height, -1), (BlockState)((Block)TFBlocks.FIREFLY.get()).defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.NORTH));
        }
    }

    private static void setIfEmpty(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isEmptyBlock(pos)) {
            world.setBlock(pos, state, 3);
        }
    }

    public static BlockState transferAllStateKeys(BlockState stateIn, Block blockOut) {
        return FeaturePlacers.transferAllStateKeys(stateIn, blockOut.defaultBlockState());
    }

    public static BlockState transferAllStateKeys(BlockState stateIn, BlockState stateOut) {
        for (Property property : stateOut.getProperties()) {
            stateOut = FeaturePlacers.transferStateKey(stateIn, stateOut, property);
        }
        return stateOut;
    }

    public static <T extends Comparable<T>> BlockState transferStateKey(BlockState stateIn, BlockState stateOut, Property<T> property) {
        if (!stateIn.hasProperty(property) || !stateOut.hasProperty(property)) {
            return stateOut;
        }
        return (BlockState)stateOut.setValue(property, stateIn.getValue(property));
    }

    public static void traceRoot(LevelSimulatedReader worldReader, RootPlacer worldPlacer, RandomSource random, BlockStateProvider dirtRoot, Iterable<BlockPos> posTracer) {
        for (BlockPos rootPos : posTracer) {
            if (FeatureUtil.anyBelowMatch(rootPos, worldPlacer.getRootPenetrability() - 1, blockPos -> worldReader.isStateAtPosition(blockPos, FeatureLogic.ROOT_SHOULD_SKIP))) {
                return;
            }
            if (FeaturePlacers.placeIfValidRootPos(worldReader, worldPlacer, random, rootPos, dirtRoot)) continue;
            return;
        }
    }

    public static void traceExposedRoot(LevelSimulatedReader worldReader, RootPlacer worldPlacer, RandomSource random, BlockStateProvider exposedRoot, BlockStateProvider dirtRoot, Iterable<BlockPos> posTracer) {
        for (BlockPos exposedPos : posTracer) {
            if (worldReader.isStateAtPosition(exposedPos, FeatureLogic.ROOT_SHOULD_SKIP)) continue;
            if (FeatureLogic.hasEmptyNeighborExceptBelow(worldReader, exposedPos)) {
                if (FeatureUtil.anyBelowMatch(exposedPos, worldPlacer.getRootPenetrability() - 1, blockPos -> worldReader.isStateAtPosition(blockPos, state -> !FeatureLogic.worldGenReplaceable(state) && state != exposedRoot.getState(random, exposedPos)))) {
                    return;
                }
                worldPlacer.getPlacer().accept(exposedPos, exposedRoot.getState(random, exposedPos));
                continue;
            }
            if (FeaturePlacers.placeIfValidRootPos(worldReader, worldPlacer, random, exposedPos, dirtRoot)) {
                FeaturePlacers.traceRoot(worldReader, worldPlacer, random, dirtRoot, posTracer);
            }
            return;
        }
    }

    @Deprecated
    public static void replaceBlocksDome(WorldGenLevel level, BlockPos centerPos, float radius, float squish, BoundingBox chunkBox, BoundingBox structureBox, Block target, BlockState replacement) {
        float radiusSquared = radius * radius;
        BoundingBox commonRegion = BoundingBoxUtils.getIntersectionOfSBBs(chunkBox, structureBox);
        if (commonRegion == null) {
            return;
        }
        FeaturePlacers.processDomeColumn(level, centerPos, radiusSquared, commonRegion, target, replacement);
        int z = 1;
        while ((float)z <= radius) {
            int x = 0;
            while ((float)x <= radius) {
                int distSq = x * x + z * z;
                if ((float)distSq <= radiusSquared) {
                    float height = (radiusSquared - (float)distSq) * squish;
                    FeaturePlacers.processDomeColumn(level, centerPos.offset(x, 0, z), height, commonRegion, target, replacement);
                    FeaturePlacers.processDomeColumn(level, centerPos.offset(-x, 0, -z), height, commonRegion, target, replacement);
                    FeaturePlacers.processDomeColumn(level, centerPos.offset(-z, 0, x), height, commonRegion, target, replacement);
                    FeaturePlacers.processDomeColumn(level, centerPos.offset(z, 0, -x), height, commonRegion, target, replacement);
                }
                ++x;
            }
            ++z;
        }
    }

    public static void replaceBlocksDome(WorldGenLevel level, BlockPos centerPos, float radius, float squish, BoundingBox chunkBox, BoundingBox structureBox, HolderSet<Block> target, BlockState replacement) {
        float radiusSquared = radius * radius;
        BoundingBox commonRegion = BoundingBoxUtils.getIntersectionOfSBBs(chunkBox, structureBox);
        if (commonRegion == null) {
            return;
        }
        FeaturePlacers.processDomeColumn(level, centerPos, radiusSquared, commonRegion, target, replacement);
        int z = 1;
        while ((float)z <= radius) {
            int x = 0;
            while ((float)x <= radius) {
                int distSq = x * x + z * z;
                if ((float)distSq <= radiusSquared) {
                    float height = (radiusSquared - (float)distSq) * squish;
                    FeaturePlacers.processDomeColumn(level, centerPos.offset(x, 0, z), height, commonRegion, target, replacement);
                    FeaturePlacers.processDomeColumn(level, centerPos.offset(-x, 0, -z), height, commonRegion, target, replacement);
                    FeaturePlacers.processDomeColumn(level, centerPos.offset(-z, 0, x), height, commonRegion, target, replacement);
                    FeaturePlacers.processDomeColumn(level, centerPos.offset(z, 0, -x), height, commonRegion, target, replacement);
                }
                ++x;
            }
            ++z;
        }
    }

    public static void processDomeColumn(WorldGenLevel level, BlockPos pos, float height, BoundingBox mask, HolderSet<Block> target, BlockState replacement) {
        if (!mask.isInside((Vec3i)pos)) {
            return;
        }
        int dY = 0;
        while ((float)dY < height) {
            BlockPos posElevated = pos.above(dY);
            if (level.getBlockState(posElevated).is(target)) {
                level.setBlock(posElevated, replacement, 3);
            }
            ++dY;
        }
    }

    public static void processDomeColumn(WorldGenLevel level, BlockPos pos, float height, BoundingBox mask, Block target, BlockState replacement) {
        if (!mask.isInside((Vec3i)pos)) {
            return;
        }
        int dY = 0;
        while ((float)dY < height) {
            BlockPos posElevated = pos.above(dY);
            if (level.getBlockState(posElevated).is(target)) {
                level.setBlock(posElevated, replacement, 3);
            }
            ++dY;
        }
    }
}

