/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.mojang.math.Transformation;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.joml.Matrix4f;
import twilightforest.beanification.Component;

@Component
public class DisplayUtil {
    public final String tag = "twilightforest_debug_display";

    public boolean spawnBlockDisplay(Level level, BoundingBox box, BlockState displayState, float padding) {
        Transformation transform = new Transformation(new Matrix4f().scale((float)box.getXSpan() + padding * 2.0f, (float)box.getYSpan() + padding * 2.0f, (float)box.getZSpan() + padding * 2.0f));
        transform.getScale();
        DataResult serializedTransform = Transformation.EXTENDED_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)transform);
        if (serializedTransform.isError()) {
            return false;
        }
        CompoundTag entityNBT = new CompoundTag();
        entityNBT.put("transformation", serializedTransform.resultOrPartial().orElseGet(CompoundTag::new));
        entityNBT.put("block_state", (Tag)NbtUtils.writeBlockState((BlockState)displayState));
        entityNBT.put("Pos", (Tag)this.newDoubleList((float)box.minX() - padding, (float)box.minY() - padding, (float)box.minZ() - padding));
        ListTag listtag = new ListTag();
        listtag.add((Object)StringTag.valueOf((String)this.tag));
        entityNBT.put("Tags", (Tag)listtag);
        entityNBT.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.BLOCK_DISPLAY).toString());
        Optional spawned = EntityType.create((CompoundTag)entityNBT, (Level)level);
        if (spawned.isEmpty()) {
            return false;
        }
        Entity entity = (Entity)spawned.get();
        return level.addFreshEntity(entity);
    }

    public ListTag newDoubleList(double ... numbers) {
        ListTag listtag = new ListTag();
        for (double d0 : numbers) {
            listtag.add((Object)DoubleTag.valueOf((double)d0));
        }
        return listtag;
    }

    public void setTextEntity(Level level, double x, double y, double z, Display.BillboardConstraints billboardConstraint, net.minecraft.network.chat.Component name) {
        DataResult serializedBillboard;
        CompoundTag entityNBT = new CompoundTag();
        entityNBT.put("Pos", (Tag)this.newDoubleList(x, y, z));
        entityNBT.putString("text", Component.Serializer.toJson((net.minecraft.network.chat.Component)name, (HolderLookup.Provider)level.registryAccess()));
        DataResult serializedAlignment = Display.TextDisplay.Align.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)Display.TextDisplay.Align.CENTER);
        if (serializedAlignment.isSuccess()) {
            entityNBT.put("alignment", (Tag)serializedAlignment.getPartialOrThrow());
        }
        if ((serializedBillboard = Display.BillboardConstraints.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)billboardConstraint)).isSuccess()) {
            entityNBT.put("billboard", (Tag)serializedBillboard.getPartialOrThrow());
        }
        ListTag listtag = new ListTag();
        listtag.add((Object)StringTag.valueOf((String)this.tag));
        entityNBT.put("Tags", (Tag)listtag);
        entityNBT.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.TEXT_DISPLAY).toString());
        Optional spawned = EntityType.create((CompoundTag)entityNBT, (Level)level);
        if (spawned.isEmpty()) {
            return;
        }
        Entity entity = (Entity)spawned.get();
        level.addFreshEntity(entity);
    }
}

