/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import twilightforest.block.JarBlock;
import twilightforest.block.entity.MasonJarBlockEntity;
import twilightforest.components.item.JarLid;
import twilightforest.init.TFDataComponents;

public class JarItem
extends BlockItem {
    public JarItem(JarBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public ItemStack getDefaultInstance() {
        return (ItemStack)Util.make((Object)super.getDefaultInstance(), stack -> stack.set((DataComponentType)TFDataComponents.JAR_LID.get(), (Object)new JarLid(this.getBlock().getDefaultLid())));
    }

    public JarBlock getBlock() {
        return (JarBlock)super.getBlock();
    }

    public static class MasonJarItem
    extends JarItem {
        public MasonJarItem(JarBlock block, Item.Properties properties) {
            super(block, properties);
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            ItemStack storedStack;
            super.appendHoverText(stack, context, components, flag);
            ItemContainerContents contents = (ItemContainerContents)stack.getComponents().get(DataComponents.CONTAINER);
            if (contents != null && !(storedStack = contents.copyOne()).isEmpty()) {
                components.add((Component)storedStack.getDisplayName().copy().append(" x" + storedStack.getCount()).withStyle(ChatFormatting.GRAY));
            }
        }

        protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
            BlockEntity blockEntity;
            boolean flag = super.placeBlock(context, state);
            Player player = context.getPlayer();
            if (player != null && (blockEntity = context.getLevel().getBlockEntity(context.getClickedPos())) instanceof MasonJarBlockEntity) {
                MasonJarBlockEntity jarBlockEntity = (MasonJarBlockEntity)blockEntity;
                jarBlockEntity.setItemRotation(RotationSegment.convertToSegment((float)(player.getYRot() + 180.0f)));
            }
            return flag;
        }
    }
}

