/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Noises;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.world.components.chunkgenerators.AbsoluteDifferenceFunction;
import twilightforest.world.components.chunkgenerators.FocusedDensityFunction;
import twilightforest.world.components.chunkgenerators.HollowHillFunction;
import twilightforest.world.components.chunkgenerators.NoiseDensityRouter;
import twilightforest.world.components.chunkgenerators.SqrtDensityFunction;
import twilightforest.world.components.chunkgenerators.TerrainDensityRouter;
import twilightforest.world.components.layer.BiomeDensitySource;

public class TFDensityFunctions {
    public static final DeferredRegister<MapCodec<? extends DensityFunction>> DENSITY_FUNCTION_TYPES = DeferredRegister.create((ResourceKey)Registries.DENSITY_FUNCTION_TYPE, (String)"twilightforest");
    public static final DeferredHolder<MapCodec<? extends DensityFunction>, MapCodec<TerrainDensityRouter>> BIOME_DRIVEN_TERRAIN = TFDensityFunctions.register("biome_driven_terrain", TerrainDensityRouter.CODEC);
    public static final DeferredHolder<MapCodec<? extends DensityFunction>, MapCodec<NoiseDensityRouter>> BIOME_DRIVEN_NOISE = TFDensityFunctions.register("biome_driven_noise", NoiseDensityRouter.CODEC);
    public static final DeferredHolder<MapCodec<? extends DensityFunction>, MapCodec<FocusedDensityFunction>> FOCUSED = TFDensityFunctions.register("focused", FocusedDensityFunction.CODEC);
    public static final DeferredHolder<MapCodec<? extends DensityFunction>, MapCodec<HollowHillFunction>> HOLLOW_HILL = TFDensityFunctions.register("hollow_hill", HollowHillFunction.CODEC);
    public static final DeferredHolder<MapCodec<? extends DensityFunction>, MapCodec<AbsoluteDifferenceFunction.Min>> COORD_MIN = TFDensityFunctions.register("coord_min", AbsoluteDifferenceFunction.Min.CODEC);
    public static final DeferredHolder<MapCodec<? extends DensityFunction>, MapCodec<AbsoluteDifferenceFunction.Max>> COORD_MAX = TFDensityFunctions.register("coord_max", AbsoluteDifferenceFunction.Max.CODEC);
    public static final DeferredHolder<MapCodec<? extends DensityFunction>, MapCodec<SqrtDensityFunction>> SQRT = TFDensityFunctions.register("sqrt", SqrtDensityFunction.CODEC);
    public static final ResourceKey<DensityFunction> BIOME_TERRAIN_RAW = ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)TwilightForestMod.prefix("raw_biome_terrain"));
    public static final ResourceKey<DensityFunction> BIOME_NOISE_RAW = ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)TwilightForestMod.prefix("raw_biome_noise"));
    public static final ResourceKey<DensityFunction> FORESTED_TERRAIN = ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)TwilightForestMod.prefix("forested_terrain"));
    public static final ResourceKey<DensityFunction> SKYLIGHT_TERRAIN = ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)TwilightForestMod.prefix("skylight_terrain"));

    private static <T extends DensityFunction> DeferredHolder<MapCodec<? extends DensityFunction>, MapCodec<T>> register(String name, MapCodec<T> keyCodec) {
        return DENSITY_FUNCTION_TYPES.register(name, () -> keyCodec);
    }

    public static void bootstrap(BootstrapContext<DensityFunction> context) {
        Holder.Reference biomeGrid = context.lookup(TFRegistries.Keys.BIOME_TERRAIN_DATA).getOrThrow(BiomeLayerStack.BIOME_GRID);
        DensityFunction referencedBiomeDensity = TFDensityFunctions.makeBiomeDensityRaw(context, (Holder.Reference<BiomeDensitySource>)biomeGrid);
        DensityFunction ambientTerrainNoise = TFDensityFunctions.makeAmbientNoise2D(context);
        DensityFunction referencedNoiseDensity = TFDensityFunctions.makeStreamDensityRaw(context, (Holder.Reference<BiomeDensitySource>)biomeGrid);
        TFDensityFunctions.makeForestedTerrain(context, referencedBiomeDensity, ambientTerrainNoise, referencedNoiseDensity);
        TFDensityFunctions.makeSkylightTerrain(context, referencedBiomeDensity, ambientTerrainNoise);
    }

    @NotNull
    private static DensityFunction makeBiomeDensityRaw(BootstrapContext<DensityFunction> context, Holder.Reference<BiomeDensitySource> biomeGrid) {
        TerrainDensityRouter rawBiomeDensityReferenced = new TerrainDensityRouter((Holder<BiomeDensitySource>)biomeGrid, -31.0, 64.0, 1.0, DensityFunctions.constant((double)8.0), DensityFunctions.constant((double)-1.25));
        return new DensityFunctions.HolderHolder((Holder)context.register(BIOME_TERRAIN_RAW, (Object)rawBiomeDensityReferenced));
    }

    @NotNull
    private static DensityFunction makeAmbientNoise2D(BootstrapContext<DensityFunction> context) {
        HolderGetter noiseLookup = context.lookup(Registries.NOISE);
        Holder.Reference surfaceParams = noiseLookup.getOrThrow(Noises.SURFACE);
        Holder.Reference ridgeParams = noiseLookup.getOrThrow(Noises.RIDGE);
        DensityFunction noiseInterpolator = TFDensityFunctions.mulAddHalf(DensityFunctions.noise((Holder)surfaceParams, (double)1.0, (double)0.0));
        DensityFunction wideNoise = TFDensityFunctions.mulAddHalf(DensityFunctions.noise((Holder)ridgeParams, (double)1.0, (double)0.0));
        DensityFunction thinNoise = TFDensityFunctions.mulAddHalf(DensityFunctions.noise((Holder)ridgeParams, (double)4.0, (double)0.0));
        DensityFunction jitteredNoise = DensityFunctions.lerp((DensityFunction)noiseInterpolator.clamp(0.0, 1.0), (DensityFunction)wideNoise, (DensityFunction)thinNoise);
        return DensityFunctions.flatCache((DensityFunction)jitteredNoise);
    }

    @NotNull
    private static DensityFunction makeStreamDensityRaw(BootstrapContext<DensityFunction> context, Holder.Reference<BiomeDensitySource> biomeGrid) {
        NoiseDensityRouter rawStreamDensityReferenced = new NoiseDensityRouter((Holder<BiomeDensitySource>)biomeGrid, -31.0, 64.0, 1.0);
        return new DensityFunctions.HolderHolder((Holder)context.register(BIOME_NOISE_RAW, (Object)rawStreamDensityReferenced));
    }

    @NotNull
    private static DensityFunction mulAddHalf(DensityFunction input) {
        return DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)0.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)0.5), (DensityFunction)input));
    }

    private static void makeForestedTerrain(BootstrapContext<DensityFunction> context, DensityFunction rawBiomeDensity, DensityFunction ambientTerrainNoise, DensityFunction rawNoiseDensity) {
        DensityFunction biomedLandscape = DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)0.1666666716337204), (DensityFunction)DensityFunctions.add((DensityFunction)rawBiomeDensity, (DensityFunction)DensityFunctions.yClampedGradient((int)-31, (int)256, (double)31.0, (double)-256.0)));
        DensityFunction finalDensity = DensityFunctions.add((DensityFunction)biomedLandscape, (DensityFunction)DensityFunctions.mul((DensityFunction)rawNoiseDensity, (DensityFunction)DensityFunctions.interpolated((DensityFunction)DensityFunctions.max((DensityFunction)DensityFunctions.zero(), (DensityFunction)ambientTerrainNoise))));
        context.register(FORESTED_TERRAIN, (Object)finalDensity.clamp(-0.1, 0.5));
    }

    private static void makeSkylightTerrain(BootstrapContext<DensityFunction> context, DensityFunction rawBiomeDensity, DensityFunction ambientTerrainNoise) {
        DensityFunction skyIslandNoise = DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.5), (DensityFunction)ambientTerrainNoise), (DensityFunction)DensityFunctions.constant((double)5.0)));
        DensityFunction biomeDensity = DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-0.25), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.add((DensityFunction)rawBiomeDensity, (DensityFunction)DensityFunctions.yClampedGradient((int)-31, (int)256, (double)31.0, (double)-256.0)), (DensityFunction)DensityFunctions.constant((double)-1.0)).halfNegative().abs());
        DensityFunction finalDensity = DensityFunctions.add((DensityFunction)new SqrtDensityFunction(DensityFunctions.interpolated((DensityFunction)skyIslandNoise).clamp(0.0, 2.0)), (DensityFunction)biomeDensity);
        context.register(SKYLIGHT_TERRAIN, (Object)finalDensity.clamp(-0.1, 0.5));
    }
}

