/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.enums;

import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public enum BlockLoggingEnum implements StringRepresentable
{
    AIR(Blocks.AIR, Fluids.EMPTY),
    WATER(Blocks.WATER, (Fluid)Fluids.WATER),
    LAVA(Blocks.LAVA, (Fluid)Fluids.LAVA),
    OBSIDIAN(Blocks.OBSIDIAN, Fluids.EMPTY),
    STONE(Blocks.STONE, Fluids.EMPTY),
    BASALT(Blocks.BASALT, Fluids.EMPTY);

    public static final EnumProperty<BlockLoggingEnum> MULTILOGGED;
    private final Block block;
    private final Fluid fluid;
    private final String name;

    private BlockLoggingEnum(Block block, Fluid fluid) {
        this.block = block;
        this.fluid = fluid;
        this.name = this.name().toLowerCase(Locale.ROOT);
        if (fluid != Fluids.EMPTY && block.defaultBlockState().liquid()) {
            Ref.FLUIDS.put(fluid, this);
        }
        if (fluid == Fluids.EMPTY && block != Blocks.AIR) {
            Ref.BLOCKS.put(block, this);
        }
    }

    public static BlockLoggingEnum getFromFluid(Fluid fluid) {
        return Ref.FLUIDS.getOrDefault(fluid, AIR);
    }

    public static BlockLoggingEnum getFromBlock(Block block) {
        return Ref.BLOCKS.getOrDefault(block, AIR);
    }

    public String getSerializedName() {
        return this.name;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public Block getBlock() {
        return this.block;
    }

    static {
        MULTILOGGED = EnumProperty.create((String)"multilogged", BlockLoggingEnum.class);
    }

    private static class Ref {
        private static final HashMap<Fluid, BlockLoggingEnum> FLUIDS = new HashMap();
        private static final HashMap<Block, BlockLoggingEnum> BLOCKS = new HashMap();

        private Ref() {
        }
    }

    public static interface IMultiLoggable
    extends BucketPickup,
    LiquidBlockContainer {
        default public ItemStack pickupBlock(@Nullable Player player, LevelAccessor world, BlockPos pos, BlockState state) {
            Fluid stateFluid = ((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).fluid;
            if (stateFluid != Fluids.EMPTY) {
                world.setBlock(pos, (BlockState)state.setValue(MULTILOGGED, (Comparable)((Object)AIR)), 3);
            }
            return new ItemStack((ItemLike)stateFluid.getBucket());
        }

        default public boolean canPlaceLiquid(@Nullable Player player, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
            return state.hasProperty(MULTILOGGED) && Ref.FLUIDS.containsKey(fluid) && !fluid.equals(((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).fluid) && state.getValue(MULTILOGGED) == AIR;
        }

        default public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
            Fluid stateFluid = ((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).fluid;
            if (stateFluid != fluidState.getType() && Ref.FLUIDS.containsKey(fluidState.getType())) {
                if (!world.isClientSide()) {
                    world.setBlock(pos, (BlockState)state.setValue(MULTILOGGED, (Comparable)((Object)Ref.FLUIDS.get(fluidState.getType()))), 3);
                    world.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)world));
                }
                return true;
            }
            return false;
        }

        default public Optional<SoundEvent> getPickupSound() {
            return Optional.empty();
        }

        default public Optional<SoundEvent> getPickupSound(BlockState state) {
            return ((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).fluid.getPickupSound();
        }
    }
}

