/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.projectile.LichBolt;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.entity.projectile.TwilightWandBolt;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;

public class LichBomb
extends TFThrowable {
    public LichBomb(EntityType<? extends LichBomb> type, Level world) {
        super(type, world);
    }

    public LichBomb(Level world, LivingEntity thrower) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.LICH_BOMB.get()), world, thrower);
    }

    public void tick() {
        super.tick();
        this.makeTrail();
    }

    private void makeTrail() {
        for (int i = 0; i < 1; ++i) {
            double sx = 0.5 * (this.random.nextDouble() - this.random.nextDouble()) + this.getDeltaMovement().x();
            double sy = 0.5 * (this.random.nextDouble() - this.random.nextDouble()) + this.getDeltaMovement().y();
            double sz = 0.5 * (this.random.nextDouble() - this.random.nextDouble()) + this.getDeltaMovement().z();
            double dx = this.getX() - sx;
            double dy = this.getY() - sy;
            double dz = this.getZ() - sz;
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, dx, dy, dz, sx * -0.25, sy * -0.25, sz * -0.25);
        }
    }

    public boolean isOnFire() {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean hurt(DamageSource source, float amount) {
        super.hurt(source, amount);
        if (source.getDirectEntity() != null) {
            if (!source.is(DamageTypeTags.IS_EXPLOSION)) {
                this.explode();
            }
            return true;
        }
        return false;
    }

    private void explode() {
        if (!this.level().isClientSide()) {
            this.level().explode((Entity)this, TFDamageTypes.getIndirectEntityDamageSource(this.level(), TFDamageTypes.LICH_BOMB, (Entity)this, this.getOwner(), (EntityType)TFEntities.LICH.get()), null, this.getX(), this.getY(), this.getZ(), 2.0f, false, Level.ExplosionInteraction.NONE);
            this.discard();
        }
    }

    protected double getDefaultGravity() {
        return 0.001f;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.explode();
    }

    protected boolean canHitEntity(Entity target) {
        Lich lich;
        if (target instanceof Lich && ((lich = (Lich)target).getTeleportInvisibility() > 0 || !(this.getOwner() instanceof Player))) {
            return false;
        }
        return !(target instanceof LichBomb) && !(target instanceof Lich) && !(target instanceof LichBolt) && !(target instanceof TwilightWandBolt);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }
}

